/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecyclePair;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.ReverseLifecyclePhase;
import org.mule.lifecycle.DefaultLifecycleState;
import org.mule.lifecycle.phases.NotInLifecyclePhase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLifecycleManager
implements LifecycleManager,
MuleContextAware {
    protected static final Log logger = LogFactory.getLog(AbstractLifecycleManager.class);
    protected static final NotInLifecyclePhase notInLifecyclePhase = new NotInLifecyclePhase();
    protected static final Set<String> DIRECT_TRANSITIONS;
    protected String currentPhase = notInLifecyclePhase.getName();
    protected String executingPhase = null;
    protected Set<String> completedPhases = new LinkedHashSet<String>(6);
    protected Set<String> transitions = new LinkedHashSet<String>(6);
    protected List<LifecyclePair> lifecyclePairs = new ArrayList<LifecyclePair>(3);
    protected LifecycleState state = this.createLifecycleState();
    protected MuleContext muleContext;
    private List<LifecyclePhase> index;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected LifecycleState createLifecycleState() {
        return new DefaultLifecycleState(this);
    }

    @Override
    public List<LifecyclePair> getLifecyclePairs() {
        return this.lifecyclePairs;
    }

    @Override
    public void setLifecyclePairs(List<LifecyclePair> lifecyclePairs) {
        this.lifecyclePairs = lifecyclePairs;
    }

    @Override
    public void registerLifecycle(LifecyclePair lifecyclePair) {
        this.lifecyclePairs.add(lifecyclePair);
    }

    protected List<LifecyclePhase> getPhasesIndex() {
        if (this.index == null) {
            this.index = new ArrayList<LifecyclePhase>(this.lifecyclePairs.size() * 2 + 1);
            this.index.add(notInLifecyclePhase);
            for (LifecyclePair pair : this.lifecyclePairs) {
                this.index.add(pair.getBegin());
            }
            for (int i = this.lifecyclePairs.size() - 1; i >= 0; --i) {
                this.index.add(this.lifecyclePairs.get(i).getEnd());
            }
        }
        return this.index;
    }

    protected synchronized int getPhaseIndex(String phase) {
        int i = 0;
        for (LifecyclePhase lifecyclePhase : this.getPhasesIndex()) {
            if (lifecyclePhase.getName().equals(phase)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected synchronized LifecyclePhase getPhaseForIndex(int phaseIndex) {
        return this.getPhasesIndex().get(phaseIndex);
    }

    protected abstract void doApplyPhase(LifecyclePhase var1) throws LifecycleException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokePhase(LifecyclePhase phase) throws LifecycleException {
        try {
            this.setExecutingPhase(phase.getName());
            this.doApplyPhase(phase);
            this.setCurrentPhase(phase);
        }
        finally {
            this.setExecutingPhase(null);
        }
    }

    @Override
    public void applyPhase(Object object, String phase) throws LifecycleException {
        int current = this.getPhaseIndex(this.currentPhase);
        int end = this.getPhaseIndex(phase);
        if (end < current) {
            logger.warn((Object)("Phase: " + phase + " has already been fired for this object: " + object));
            return;
        }
        ++current;
        while (current <= end) {
            LifecyclePhase li = this.getPhaseForIndex(current);
            li.applyLifecycle(object);
            ++current;
        }
    }

    @Override
    public void fireLifecycle(String destinationPhase) throws LifecycleException {
        this.checkPhase(destinationPhase);
        if (this.isDirectTransition(destinationPhase)) {
            LifecyclePhase phase = this.lookupPhase(destinationPhase);
            this.invokePhase(phase);
        } else {
            int current = this.getPhaseIndex(this.currentPhase);
            int end = this.getPhaseIndex(destinationPhase);
            if (end < current) {
                LifecyclePhase phase = this.getPhaseForIndex(end);
                this.invokePhase(phase);
                return;
            }
            ++current;
            while (current <= end) {
                LifecyclePhase phase = this.getPhaseForIndex(current);
                this.invokePhase(phase);
                ++current;
            }
        }
    }

    protected boolean isDirectTransition(String destinationPhase) {
        String key = this.getCurrentPhase() + "-" + destinationPhase;
        return DIRECT_TRANSITIONS.contains(key);
    }

    @Override
    public String getCurrentPhase() {
        return this.currentPhase;
    }

    @Override
    public String getExecutingPhase() {
        return this.executingPhase;
    }

    protected synchronized void setCurrentPhase(LifecyclePhase phase) {
        if (phase instanceof ReverseLifecyclePhase) {
            this.transitions.remove(phase.getOppositeLifecyclePhase());
            this.currentPhase = this.completedPhases.toArray(new String[0])[this.completedPhases.size() - 2];
        } else {
            this.completedPhases.add(phase.getName());
            this.transitions.add(phase.getName());
            this.transitions.remove(phase.getOppositeLifecyclePhase());
            this.currentPhase = phase.getName();
        }
    }

    protected synchronized void setExecutingPhase(String phase) {
        this.executingPhase = phase;
    }

    @Override
    public void reset() {
        this.setExecutingPhase(null);
        this.completedPhases.clear();
        this.transitions.clear();
        this.setCurrentPhase(notInLifecyclePhase);
    }

    @Override
    public boolean isPhaseComplete(String phaseName) {
        return this.transitions.contains(phaseName);
    }

    @Override
    public void applyCompletedPhases(Object object) throws LifecycleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("applying lifecycle to " + object));
        }
        Iterator<String> i$ = this.completedPhases.iterator();
        while (i$.hasNext()) {
            String completedPhase;
            String phase = completedPhase = i$.next();
            int phaseIndex = this.getPhaseIndex(phase);
            LifecyclePhase lcp = this.getPhaseForIndex(phaseIndex);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("phase: " + lcp));
            }
            lcp.applyLifecycle(object);
            if (!phase.equals(this.getCurrentPhase())) continue;
            break;
        }
    }

    @Override
    public void checkPhase(String name) throws IllegalStateException {
        if (this.executingPhase != null) {
            if (name.equalsIgnoreCase(this.executingPhase)) {
                throw new IllegalStateException("Phase '" + name + "' is already currently being executed");
            }
            throw new IllegalStateException("Currently executing lifecycle phase: " + this.executingPhase);
        }
        if (name.equalsIgnoreCase(this.currentPhase)) {
            throw new IllegalStateException("Already in lifecycle phase '" + name + "', cannot fire the same phase twice");
        }
        int phaseIndex = this.getPhaseIndex(name);
        if (phaseIndex == -1) {
            throw new IllegalStateException("Phase does not exist: " + name);
        }
        if ("dispose".equals(name)) {
            return;
        }
        if (this.index.get(phaseIndex - 1).getName().equals(this.getCurrentPhase())) {
            return;
        }
        for (LifecyclePair pair : this.lifecyclePairs) {
            if ((!pair.getBegin().getName().equals(name) || !pair.getEnd().getName().equals(this.getCurrentPhase())) && (!pair.getEnd().getName().equals(name) || !pair.getBegin().getName().equals(this.getCurrentPhase()))) continue;
            return;
        }
        throw new IllegalStateException("Lifecycle phase: " + this.currentPhase + " does not support phase: " + name);
    }

    protected LifecyclePhase lookupPhase(String phase) throws IllegalArgumentException {
        int phaseIndex = this.getPhaseIndex(phase);
        if (phaseIndex == -1) {
            throw new IllegalArgumentException("No lifecycle phase registered with name: " + phase);
        }
        return this.getPhaseForIndex(phaseIndex);
    }

    @Override
    public LifecycleState getState() {
        return this.state;
    }

    static {
        HashSet<String> directTransitions = new HashSet<String>();
        directTransitions.add("not in lifecycle-dispose");
        directTransitions.add("initialise-dispose");
        DIRECT_TRANSITIONS = Collections.unmodifiableSet(directTransitions);
    }
}

