/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Properties;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.EndpointURIBuilder;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.util.PropertiesUtils;

public abstract class AbstractEndpointURIBuilder
implements EndpointURIBuilder {
    protected String address;
    protected String endpointName;
    protected String connectorName;
    protected String transformers;
    protected String responseTransformers;
    protected String userInfo;
    private URI uri;

    public EndpointURI build(URI uri, MuleContext muleContext) throws MalformedEndpointException {
        this.uri = uri;
        Properties props = this.getPropertiesForURI(uri, muleContext);
        String replaceAddress = null;
        if (this.address != null) {
            replaceAddress = this.address;
            this.setEndpoint(uri, props);
            this.address = replaceAddress;
        } else {
            this.setEndpoint(uri, props);
        }
        MuleEndpointURI ep = new MuleEndpointURI(this.address, this.endpointName, this.connectorName, this.transformers, this.responseTransformers, props, this.uri, this.userInfo, muleContext);
        this.address = null;
        this.endpointName = null;
        this.connectorName = null;
        this.transformers = null;
        this.responseTransformers = null;
        uri = null;
        return ep;
    }

    protected void rewriteURI(URI newURI) {
        this.uri = newURI;
    }

    protected abstract void setEndpoint(URI var1, Properties var2) throws MalformedEndpointException;

    protected Properties getPropertiesForURI(URI uri, MuleContext muleContext) throws MalformedEndpointException {
        String cnnName;
        String endpoint;
        Properties properties = PropertiesUtils.getPropertiesFromQueryString(uri.getQuery());
        String tempEndpointName = (String)properties.get("endpointName");
        if (tempEndpointName != null) {
            this.endpointName = tempEndpointName;
        }
        if ((endpoint = (String)properties.get("address")) != null) {
            this.address = endpoint;
            this.address = this.decode(this.address, uri, muleContext);
        }
        if ((cnnName = (String)properties.get("connector")) != null) {
            this.connectorName = cnnName;
        }
        this.transformers = (String)properties.get("transformers");
        if (this.transformers != null) {
            this.transformers = this.transformers.replaceAll(" ", ",");
        }
        this.responseTransformers = (String)properties.get("responseTransformers");
        if (this.responseTransformers != null) {
            this.responseTransformers = this.responseTransformers.replaceAll(" ", ",");
        }
        this.userInfo = uri.getUserInfo();
        return properties;
    }

    private String decode(String string, URI uri, MuleContext context) throws MalformedEndpointException {
        try {
            String encoding = "UTF-8";
            if (context != null) {
                encoding = context.getConfiguration().getDefaultEncoding();
            }
            return URLDecoder.decode(string, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new MalformedEndpointException(uri.toString(), (Throwable)e);
        }
    }
}

