/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context;

import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ConnectionNotificationListener;
import org.mule.api.context.notification.CustomNotificationListener;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ManagementNotificationListener;
import org.mule.api.context.notification.ModelNotificationListener;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.RegistryNotificationListener;
import org.mule.api.context.notification.RoutingNotificationListener;
import org.mule.api.context.notification.SecurityNotificationListener;
import org.mule.api.context.notification.ServiceNotificationListener;
import org.mule.api.context.notification.TransactionNotificationListener;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecyclePair;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.CustomNotification;
import org.mule.context.notification.ExceptionNotification;
import org.mule.context.notification.ManagementNotification;
import org.mule.context.notification.ModelNotification;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.RegistryNotification;
import org.mule.context.notification.RoutingNotification;
import org.mule.context.notification.SecurityNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.context.notification.ServiceNotification;
import org.mule.context.notification.TransactionNotification;
import org.mule.lifecycle.DefaultLifecyclePair;
import org.mule.lifecycle.MuleContextLifecycleManager;
import org.mule.lifecycle.phases.MuleContextDisposePhase;
import org.mule.lifecycle.phases.MuleContextInitialisePhase;
import org.mule.lifecycle.phases.MuleContextStartPhase;
import org.mule.lifecycle.phases.MuleContextStopPhase;
import org.mule.util.ClassUtils;
import org.mule.util.SplashScreen;
import org.mule.work.DefaultWorkListener;
import org.mule.work.MuleWorkManager;

public class DefaultMuleContextBuilder
implements MuleContextBuilder {
    protected static final Log logger = LogFactory.getLog(DefaultMuleContextBuilder.class);
    protected MuleConfiguration config;
    protected MuleContextLifecycleManager lifecycleManager;
    protected WorkManager workManager;
    protected WorkListener workListener;
    protected ServerNotificationManager notificationManager;
    protected SplashScreen startupScreen;
    protected SplashScreen shutdownScreen;

    public MuleContext buildMuleContext() {
        logger.debug((Object)("Building new DefaultMuleContext instance with MuleContextBuilder: " + this));
        MuleContextLifecycleManager manager = this.getLifecycleManager();
        DefaultMuleContext muleContext = new DefaultMuleContext(this.getMuleConfiguration(), this.getWorkManager(), this.getWorkListener(), manager, this.getNotificationManager());
        manager.setMuleContext(muleContext);
        muleContext.setSplash(this.startupScreen, this.shutdownScreen);
        return muleContext;
    }

    public void setMuleConfiguration(MuleConfiguration config) {
        this.config = config;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void setWorkListener(WorkListener workListener) {
        this.workListener = workListener;
    }

    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    protected MuleConfiguration getMuleConfiguration() {
        if (this.config != null) {
            return this.config;
        }
        return new DefaultMuleConfiguration();
    }

    protected MuleContextLifecycleManager getLifecycleManager() {
        if (this.lifecycleManager != null) {
            return this.lifecycleManager;
        }
        MuleContextLifecycleManager manager = new MuleContextLifecycleManager();
        this.addRequiredLifecyclePairs(manager);
        return manager;
    }

    public void setLifecycleManager(LifecycleManager manager) {
        if (!(manager instanceof MuleContextLifecycleManager)) {
            Message msg = MessageFactory.createStaticMessage("lifecycle manager for MuleContext must be a MuleContextLifecycleManager");
            throw new MuleRuntimeException(msg);
        }
        MuleContextLifecycleManager contextManager = (MuleContextLifecycleManager)manager;
        this.addRequiredLifecyclePairs(contextManager);
        this.lifecycleManager = contextManager;
    }

    protected void addRequiredLifecyclePairs(MuleContextLifecycleManager contextManager) {
        boolean initializeDisposePairPresent = false;
        boolean startStopPairPresent = false;
        for (LifecyclePair pair : contextManager.getLifecyclePairs()) {
            if (pair.getBegin() instanceof MuleContextInitialisePhase && pair.getEnd() instanceof MuleContextDisposePhase) {
                initializeDisposePairPresent = true;
            }
            if (!(pair.getBegin() instanceof MuleContextStartPhase) || !(pair.getEnd() instanceof MuleContextStopPhase)) continue;
            startStopPairPresent = true;
        }
        if (!initializeDisposePairPresent) {
            this.registerInitializeDisposeLifecyclePair(contextManager);
        }
        if (!startStopPairPresent) {
            this.registerStartStopLifecyclePair(contextManager);
        }
    }

    protected void registerInitializeDisposeLifecyclePair(MuleContextLifecycleManager manager) {
        DefaultLifecyclePair pair = new DefaultLifecyclePair(new MuleContextInitialisePhase(), new MuleContextDisposePhase());
        manager.registerLifecycle(pair);
    }

    private void registerStartStopLifecyclePair(MuleContextLifecycleManager manager) {
        manager.registerLifecycle(new DefaultLifecyclePair(new MuleContextStartPhase(), new MuleContextStopPhase()));
    }

    protected WorkManager getWorkManager() {
        if (this.workManager != null) {
            return this.workManager;
        }
        return new MuleWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, "MuleServer", this.getMuleConfiguration().getShutdownTimeout());
    }

    protected WorkListener getWorkListener() {
        if (this.workListener != null) {
            return this.workListener;
        }
        return new DefaultWorkListener();
    }

    protected ServerNotificationManager getNotificationManager() {
        if (this.notificationManager != null) {
            return this.notificationManager;
        }
        ServerNotificationManager manager = new ServerNotificationManager();
        manager.addInterfaceToType(MuleContextNotificationListener.class, MuleContextNotification.class);
        manager.addInterfaceToType(ModelNotificationListener.class, ModelNotification.class);
        manager.addInterfaceToType(RoutingNotificationListener.class, RoutingNotification.class);
        manager.addInterfaceToType(ServiceNotificationListener.class, ServiceNotification.class);
        manager.addInterfaceToType(SecurityNotificationListener.class, SecurityNotification.class);
        manager.addInterfaceToType(ManagementNotificationListener.class, ManagementNotification.class);
        manager.addInterfaceToType(CustomNotificationListener.class, CustomNotification.class);
        manager.addInterfaceToType(ConnectionNotificationListener.class, ConnectionNotification.class);
        manager.addInterfaceToType(RegistryNotificationListener.class, RegistryNotification.class);
        manager.addInterfaceToType(ExceptionNotificationListener.class, ExceptionNotification.class);
        manager.addInterfaceToType(TransactionNotificationListener.class, TransactionNotification.class);
        return manager;
    }

    public SplashScreen getStartupScreen() {
        return this.startupScreen;
    }

    public void setStartupScreen(SplashScreen startupScreen) {
        this.startupScreen = startupScreen;
    }

    public SplashScreen getShutdownScreen() {
        return this.shutdownScreen;
    }

    public void setShutdownScreen(SplashScreen shutdownScreen) {
        this.shutdownScreen = shutdownScreen;
    }

    public String toString() {
        return ClassUtils.getClassName(this.getClass()) + "{muleConfiguration=" + this.config + ", lifecycleManager=" + this.lifecycleManager + ", workManager=" + this.workManager + ", workListener=" + this.workListener + ", notificationManager=" + this.notificationManager + "}";
    }
}

