/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import org.mule.api.MuleException;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.model.ModelException;
import org.mule.api.object.ObjectFactory;
import org.mule.api.routing.BindingCollection;
import org.mule.component.AbstractJavaComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;

public class DefaultJavaComponent
extends AbstractJavaComponent {
    protected LifecycleAdapter singletonComponentLifecycleAdapter;

    public DefaultJavaComponent() {
    }

    public DefaultJavaComponent(ObjectFactory objectFactory) {
        super(objectFactory);
    }

    public DefaultJavaComponent(ObjectFactory objectFactory, EntryPointResolverSet entryPointResolverSet, BindingCollection bindingCollection) {
        super(objectFactory, entryPointResolverSet, bindingCollection);
    }

    protected void doStart() throws MuleException {
        super.doStart();
        if (this.objectFactory != null && this.objectFactory.isSingleton()) {
            try {
                if (this.singletonComponentLifecycleAdapter == null) {
                    this.singletonComponentLifecycleAdapter = this.createLifecycleAdaptor();
                }
            }
            catch (Exception e) {
                throw new InitialisationException(MessageFactory.createStaticMessage("Unable to create instance of POJO service"), (Throwable)e, this);
            }
            if (!this.singletonComponentLifecycleAdapter.isStarted()) {
                try {
                    this.singletonComponentLifecycleAdapter.start();
                }
                catch (Exception e) {
                    throw new ModelException(CoreMessages.failedToStart("Service '" + this.service.getName() + "'"), (Throwable)e);
                }
            }
        }
    }

    protected void doStop() throws MuleException {
        super.doStop();
        if (this.singletonComponentLifecycleAdapter != null && this.singletonComponentLifecycleAdapter.isStarted()) {
            try {
                this.singletonComponentLifecycleAdapter.stop();
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToStop("Service '" + this.service.getName() + "'"), (Throwable)e);
            }
        }
    }

    protected void doDispose() {
        super.doDispose();
        if (this.singletonComponentLifecycleAdapter != null) {
            this.singletonComponentLifecycleAdapter.dispose();
        }
    }

    protected LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception {
        LifecycleAdapter componentLifecycleAdapter;
        if (this.singletonComponentLifecycleAdapter != null) {
            componentLifecycleAdapter = this.singletonComponentLifecycleAdapter;
        } else {
            componentLifecycleAdapter = this.createLifecycleAdaptor();
            componentLifecycleAdapter.start();
        }
        return componentLifecycleAdapter;
    }

    protected void returnComponentLifecycleAdaptor(LifecycleAdapter lifecycleAdapter) throws Exception {
        if (this.singletonComponentLifecycleAdapter == null && lifecycleAdapter != null) {
            lifecycleAdapter.stop();
            lifecycleAdapter.dispose();
            lifecycleAdapter = null;
        }
    }
}

