/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.VoidResult;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.interceptor.Invocation;
import org.mule.api.lifecycle.DisposeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceException;
import org.mule.api.transformer.TransformerException;
import org.mule.component.ComponentInterceptorInvoker;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ComponentMessageNotification;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.mule.management.stats.ComponentStatistics;
import org.mule.transformer.TransformerTemplate;
import org.mule.transport.NullPayload;

public abstract class AbstractComponent
implements Component,
Interceptor,
MuleContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Service service;
    protected ComponentStatistics statistics = null;
    protected ServerNotificationHandler notificationHandler;
    protected List interceptors = new ArrayList();
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public List getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List interceptors) {
        this.interceptors = interceptors;
    }

    public AbstractComponent() {
        this.statistics = new ComponentStatistics();
    }

    public MuleMessage intercept(Invocation invocation) throws MuleException {
        return this.invokeInternal(invocation.getEvent());
    }

    private MuleMessage invokeInternal(MuleEvent event) throws DisposeException, DefaultMuleException, MuleException, ServiceException {
        OptimizedRequestContext.unsafeSetEvent(event);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking " + this.getClass().getName() + "component for service " + this.service.getName()));
        }
        if (!(event.getEndpoint() instanceof InboundEndpoint)) {
            throw new IllegalStateException("Unable to process outbound event, components only process incoming events.");
        }
        if (this.service.getLifecycleManager().getState().isStopping() || !this.service.getLifecycleManager().getState().isStarted()) {
            throw new DefaultMuleException(CoreMessages.componentIsStopped(this.service.getName()));
        }
        try {
            this.fireComponentNotification(event.getMessage(), 1401);
            long startTime = 0L;
            if (this.statistics.isEnabled()) {
                startTime = System.currentTimeMillis();
            }
            Object result = this.doInvoke(event);
            if (this.statistics.isEnabled()) {
                this.statistics.addExecutionTime(System.currentTimeMillis() - startTime);
            }
            MuleMessage resultMessage = this.createResultMessage(event, result);
            this.fireComponentNotification(resultMessage, 1402);
            return resultMessage;
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ServiceException(CoreMessages.failedToInvoke(this.toString()), event.getMessage(), this.service, e);
        }
    }

    public MuleMessage invoke(MuleEvent event) throws MuleException {
        if (this.interceptors.isEmpty()) {
            return this.invokeInternal(event);
        }
        return new ComponentInterceptorInvoker(this, this.interceptors, event).invoke();
    }

    protected MuleMessage createResultMessage(MuleEvent event, Object result) throws TransformerException {
        if (result instanceof MuleMessage) {
            return (MuleMessage)result;
        }
        if (result instanceof VoidResult) {
            event.transformMessage();
            return event.getMessage();
        }
        if (result != null) {
            event.getMessage().applyTransformers(Collections.singletonList(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
            return event.getMessage();
        }
        return new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext);
    }

    protected abstract Object doInvoke(MuleEvent var1) throws Exception;

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        if (this.service != null) {
            buf.append(" component for: ").append(this.service.toString());
        } else {
            buf.append(" no component");
        }
        return buf.toString();
    }

    public void release() {
    }

    public ComponentStatistics getStatistics() {
        return this.statistics;
    }

    public void setService(Service service) {
        this.service = service;
        if (this.muleContext == null && service.getMuleContext() != null) {
            this.muleContext = service.getMuleContext();
        }
    }

    public Service getService() {
        return this.service;
    }

    public final void initialise() throws InitialisationException {
        if (this.service != null && this.service.getLifecycleManager() != null && this.service.getLifecycleManager().getState().isInitialised()) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initialising: " + this));
        }
        if (this.service == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Component has not been initialized properly, no service."), (Initialisable)this);
        }
        this.doInitialise();
    }

    protected void doInitialise() throws InitialisationException {
    }

    public void dispose() {
        if (this.service.getLifecycleManager().getState().isDisposed()) {
            return;
        }
        try {
            if (this.service.getLifecycleManager().getState().isStarted()) {
                this.stop();
            }
        }
        catch (MuleException e) {
            this.logger.error((Object)CoreMessages.failedToStop(this.toString()));
        }
        try {
            this.doDispose();
        }
        catch (Exception e) {
            this.logger.warn(CoreMessages.failedToDispose(this.toString()), (Throwable)e);
        }
    }

    protected void doDispose() {
    }

    public void stop() throws MuleException {
        if (this.service.getLifecycleManager().getState().isStopped()) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping: " + this));
        }
        this.doStop();
    }

    protected void doStart() throws MuleException {
    }

    public void start() throws MuleException {
        if (this.service.getLifecycleManager().getState().isStarted()) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting: " + this));
        }
        this.notificationHandler = new OptimisedNotificationHandler(this.service.getMuleContext().getNotificationManager(), ComponentMessageNotification.class);
        this.doStart();
    }

    protected void doStop() throws MuleException {
    }

    protected void fireComponentNotification(MuleMessage message, int action) {
        if (this.notificationHandler.isNotificationEnabled(ComponentMessageNotification.class)) {
            this.notificationHandler.fireNotification(new ComponentMessageNotification(message, this, action));
        }
    }
}

