/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.MuleSessionHandler;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointNotFoundException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.security.SecurityContext;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.ReceiveException;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.UUID;
import org.mule.util.store.DeserializationPostInitialisable;

public final class DefaultMuleSession
implements MuleSession,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 3380926585676521866L;
    private static Log logger = LogFactory.getLog(DefaultMuleSession.class);
    private transient Service service = null;
    private boolean valid = true;
    private String id;
    private SecurityContext securityContext;
    private Map properties = null;
    private transient MuleContext muleContext;
    private transient Map<String, Object> serializedData = null;

    public DefaultMuleSession(MuleContext muleContext) {
        this(null, muleContext);
    }

    public DefaultMuleSession(Service service, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.properties = new CaseInsensitiveHashMap();
        this.id = UUID.getUUID();
        this.service = service;
    }

    @Deprecated
    public DefaultMuleSession(MuleMessage message, SessionHandler requestSessionHandler, Service service, MuleContext muleContext) throws MuleException {
        this(message, requestSessionHandler, muleContext);
        if (service == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("service").toString());
        }
        this.service = service;
    }

    @Deprecated
    public DefaultMuleSession(MuleMessage message, SessionHandler requestSessionHandler, MuleContext muleContext) throws MuleException {
        this(muleContext);
        if (requestSessionHandler == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("requestSessionHandler").toString());
        }
        if (message == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("message").toString());
        }
        this.properties = new CaseInsensitiveMap();
        requestSessionHandler.retrieveSessionInfoFromMessage(message, this);
        this.id = (String)this.getProperty(requestSessionHandler.getSessionIDKey());
        if (this.id == null) {
            this.id = UUID.getUUID();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("There is no session id on the request using key: " + requestSessionHandler.getSessionIDKey() + ". Generating new session id: " + this.id));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got session with id: " + this.id));
        }
    }

    public void dispatchEvent(MuleMessage message) throws MuleException {
        if (this.service == null) {
            throw new IllegalStateException(CoreMessages.objectIsNull("Service").getMessage());
        }
        OutboundRouterCollection router = this.service.getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException(CoreMessages.noOutboundRouterSetOn(this.service.getName()));
        }
        router.route(message, this);
    }

    public void dispatchEvent(MuleMessage message, String endpointName) throws MuleException {
        this.dispatchEvent(message, this.muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointName));
    }

    public void dispatchEvent(MuleMessage message, OutboundEndpoint endpoint) throws MuleException {
        if (endpoint == null) {
            logger.warn((Object)"Endpoint argument is null, using outbound router to determine endpoint.");
            this.dispatchEvent(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleSession has received asynchronous event on: " + endpoint));
        }
        MuleEvent event = this.createOutboundEvent(message, endpoint, null);
        this.dispatchEvent(event);
    }

    public MuleMessage sendEvent(MuleMessage message, String endpointName) throws MuleException {
        return this.sendEvent(message, this.muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointName));
    }

    public MuleMessage sendEvent(MuleMessage message) throws MuleException {
        if (this.service == null) {
            throw new IllegalStateException(CoreMessages.objectIsNull("Service").getMessage());
        }
        OutboundRouterCollection router = this.service.getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException(CoreMessages.noOutboundRouterSetOn(this.service.getName()));
        }
        MuleMessage result = router.route(message, this);
        return result;
    }

    public MuleMessage sendEvent(MuleMessage message, OutboundEndpoint endpoint) throws MuleException {
        if (endpoint == null) {
            logger.warn((Object)"Endpoint argument is null, using outbound router to determine endpoint.");
            return this.sendEvent(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleSession has received synchronous event on endpoint: " + endpoint));
        }
        MuleEvent event = this.createOutboundEvent(message, endpoint, null);
        MuleMessage result = this.sendEvent(event);
        if (endpoint.isSynchronous() && result != null) {
            result.applyTransformers(endpoint.getResponseTransformers());
        }
        return result;
    }

    public void dispatchEvent(MuleEvent event) throws MuleException {
        if (event.getEndpoint() instanceof OutboundEndpoint) {
            try {
                Connector connector;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("dispatching event: " + event));
                }
                if ((connector = event.getEndpoint().getConnector()) instanceof AbstractConnector) {
                    ((AbstractConnector)connector).getSessionHandler().storeSessionInfoToMessage(this, event.getMessage());
                } else {
                    logger.warn((Object)"A session handler could not be obtained, using  default");
                    new MuleSessionHandler().storeSessionInfoToMessage(this, event.getMessage());
                }
                ((OutboundEndpoint)event.getEndpoint()).dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        } else if (this.service != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dispatching event to service: " + this.service.getName() + ", event is: " + event));
            }
            this.service.dispatchEvent(event);
        } else {
            throw new DispatchException(CoreMessages.noComponentForEndpoint(), event.getMessage(), event.getEndpoint());
        }
    }

    public String getId() {
        return this.id;
    }

    public MuleMessage sendEvent(MuleEvent event) throws MuleException {
        int timeout = event.getMessage().getIntProperty("MULE_EVENT_TIMEOUT", -1);
        if (timeout >= 0) {
            event.setTimeout(timeout);
        }
        if (event.getEndpoint() instanceof OutboundEndpoint) {
            try {
                Connector connector;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sending event: " + event));
                }
                if ((connector = event.getEndpoint().getConnector()) instanceof AbstractConnector) {
                    ((AbstractConnector)connector).getSessionHandler().storeSessionInfoToMessage(this, event.getMessage());
                } else {
                    logger.warn((Object)"A session handler could not be obtained, using default.");
                    new MuleSessionHandler().storeSessionInfoToMessage(this, event.getMessage());
                }
                MuleMessage response = ((OutboundEndpoint)event.getEndpoint()).send(event);
                return OptimizedRequestContext.unsafeRewriteEvent(response);
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        if (this.service != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sending event to service: " + this.service.getName() + " event is: " + event));
            }
            return this.service.sendEvent(event);
        }
        throw new DispatchException(CoreMessages.noComponentForEndpoint(), event.getMessage(), event.getEndpoint());
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean value) {
        this.valid = value;
    }

    public MuleMessage requestEvent(String endpointName, long timeout) throws MuleException {
        InboundEndpoint endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(endpointName);
        return this.requestEvent(endpoint, timeout);
    }

    public MuleMessage requestEvent(InboundEndpoint endpoint, long timeout) throws MuleException {
        try {
            return endpoint.request(timeout);
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, e);
        }
    }

    public MuleEvent createOutboundEvent(MuleMessage message, OutboundEndpoint endpoint, MuleEvent previousEvent) throws MuleException {
        if (endpoint == null) {
            throw new DispatchException(CoreMessages.objectIsNull("Outbound Endpoint"), message, endpoint);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating event with data: " + message.getPayload().getClass().getName() + ", for endpoint: " + endpoint));
        }
        try {
            DefaultMuleEvent event = previousEvent != null ? new DefaultMuleEvent(message, (ImmutableEndpoint)endpoint, this.service, previousEvent) : new DefaultMuleEvent(message, (ImmutableEndpoint)endpoint, (MuleSession)this, false, null);
            return event;
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToCreate("MuleEvent"), message, endpoint, e);
        }
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setSecurityContext(SecurityContext context) {
        this.securityContext = context;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public Object removeProperty(Object key) {
        return this.properties.remove(key);
    }

    @Deprecated
    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public Set getPropertyNamesAsSet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.getService() != null) {
            out.writeObject(this.getService() != null ? this.getService().getName() : "null");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serializedData = new HashMap<String, Object>();
        try {
            this.serializedData.put("serviceName", in.readObject());
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }

    void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
        String serviceName = (String)this.serializedData.get("serviceName");
        if (serviceName != null) {
            this.service = muleContext.getRegistry().lookupService(serviceName);
        }
        this.serializedData = null;
    }
}

