/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessagePropertiesContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;
import org.mule.util.store.DeserializationPostInitialisable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMuleMessage
implements MuleMessage,
ThreadSafeAccess,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 1541720810851984844L;
    private static final Log logger = LogFactory.getLog(DefaultMuleMessage.class);
    private static final List<Class<?>> consumableClasses = new ArrayList();
    private String id = UUID.getUUID();
    private transient Object payload;
    private transient Object originalPayload;
    private ExceptionPayload exceptionPayload;
    private MessagePropertiesContext properties = new MessagePropertiesContext();
    private Map<String, DataHandler> attachments = new ConcurrentHashMap();
    private transient List<Integer> appliedTransformerHashCodes;
    private transient byte[] cache;
    protected transient MuleContext muleContext;
    private transient AtomicReference ownerThread = null;
    private transient AtomicBoolean mutable = null;

    private static void addToConsuableClasses(String className) {
        try {
            consumableClasses.add(ClassUtils.loadClass(className, DefaultMuleMessage.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public DefaultMuleMessage(Object message, MuleContext muleContext) {
        this(message, (Map<String, Object>)null, muleContext);
    }

    public DefaultMuleMessage(Object message, Map<String, Object> properties, MuleContext muleContext) {
        this.setMuleContext(muleContext);
        this.initAppliedTransformerHashCodes();
        if (message instanceof MuleMessage) {
            MuleMessage muleMessage = (MuleMessage)message;
            this.setPayload(muleMessage.getPayload());
            this.copyMessageProperties(muleMessage);
        } else {
            this.setPayload(message);
            this.originalPayload = message;
        }
        this.addProperties(properties);
        this.resetAccessControl();
    }

    public DefaultMuleMessage(Object message, MuleMessage previous, MuleContext muleContext) {
        this.id = previous.getUniqueId();
        this.setMuleContext(muleContext);
        this.initAppliedTransformerHashCodes();
        this.setEncoding(previous.getEncoding());
        if (message instanceof MuleMessage) {
            MuleMessage payloadMessage = (MuleMessage)message;
            this.setPayload(payloadMessage.getPayload());
            this.copyMessageProperties(payloadMessage);
        } else {
            this.setPayload(message);
            this.copyMessageProperties(previous);
        }
        this.originalPayload = previous.getPayload();
        if (previous.getExceptionPayload() != null) {
            this.setExceptionPayload(previous.getExceptionPayload());
        }
        this.copyAttachments(previous);
        this.resetAccessControl();
    }

    private void copyMessageProperties(MuleMessage muleMessage) {
        Map<String, Object> inboundProperties = ((DefaultMuleMessage)muleMessage).properties.getScopedProperties(PropertyScope.INBOUND);
        this.addInboundProperties(inboundProperties);
        for (PropertyScope scope : PropertyScope.ALL_SCOPES) {
            try {
                for (String name : muleMessage.getPropertyNames(scope)) {
                    Object value = muleMessage.getProperty(name);
                    this.setProperty(name, value, scope);
                }
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
    }

    private void copyAttachments(MuleMessage previous) {
        if (previous.getAttachmentNames().size() > 0) {
            for (String name : previous.getAttachmentNames()) {
                try {
                    this.addAttachment(name, previous.getAttachment(name));
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadAttachment(name), (Throwable)e);
                }
            }
        }
    }

    private DefaultMuleMessage(DefaultMuleMessage message) {
        this(message.getPayload(), message, message.muleContext);
    }

    private void setMuleContext(MuleContext context) {
        if (context == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("muleContext").getMessage());
        }
        this.muleContext = context;
    }

    private void initAppliedTransformerHashCodes() {
        this.appliedTransformerHashCodes = new CopyOnWriteArrayList();
    }

    @Override
    public <T> T getPayload(Class<T> outputType) throws TransformerException {
        return this.getPayload(outputType, this.getEncoding());
    }

    @Override
    public <T> T getPayload(DataType<T> outputType) throws TransformerException {
        return this.getPayload(outputType, this.getEncoding());
    }

    MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected <T> T getPayload(DataType<T> resultType, String encoding) throws TransformerException {
        if (resultType == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("resultType").getMessage());
        }
        DataType<?> source = new DataTypeFactory().create(this.getPayload().getClass());
        if (resultType.isCompatibleWith(source)) {
            return (T)this.getPayload();
        }
        Transformer transformer = this.muleContext.getRegistry().lookupTransformer(source, resultType);
        if (transformer == null) {
            throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, resultType));
        }
        Object result = transformer.transform(this, encoding);
        if (!resultType.getType().isAssignableFrom(result.getClass())) {
            throw new TransformerException(CoreMessages.transformOnObjectNotOfSpecifiedType(resultType, result));
        }
        if (this.isPayloadConsumed(source.getType())) {
            this.setPayload(result);
        }
        return (T)result;
    }

    protected <T> T getPayload(Class<T> outputType, String encoding) throws TransformerException {
        return this.getPayload(new SimpleDataType<T>(outputType), encoding);
    }

    protected boolean isPayloadConsumed(Class<?> inputCls) {
        return InputStream.class.isAssignableFrom(inputCls) || this.isConsumedFromAdditional(inputCls);
    }

    private boolean isConsumedFromAdditional(Class<?> inputCls) {
        if (consumableClasses.isEmpty()) {
            return false;
        }
        for (Class<?> c : consumableClasses) {
            if (!c.isAssignableFrom(inputCls)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public Object getOrginalPayload() {
        return this.getOriginalPayload();
    }

    @Override
    public Object getOriginalPayload() {
        return this.originalPayload;
    }

    @Override
    public void setProperty(String key, Object value, PropertyScope scope) {
        this.assertAccess(true);
        if (key != null) {
            if (value != null) {
                this.properties.setProperty(key, value, scope);
            } else {
                logger.warn((Object)("setProperty(key, value) called with null value; removing key: " + key + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
                this.properties.removeProperty(key);
            }
        } else {
            logger.warn((Object)("setProperty(key, value) ignored because of null key for object: " + value + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
        }
    }

    @Override
    public Object getProperty(String key) {
        this.assertAccess(false);
        return this.properties.getProperty(key);
    }

    @Override
    public Object removeProperty(String key) {
        this.assertAccess(true);
        return this.properties.removeProperty(key);
    }

    @Override
    public Object removeProperty(String key, PropertyScope scope) {
        this.assertAccess(true);
        return this.properties.removeProperty(key, scope);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.assertAccess(true);
        if (key != null) {
            if (value != null) {
                this.properties.setProperty(key, value);
            } else {
                logger.warn((Object)("setProperty(key, value) called with null value; removing key: " + key + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
                this.properties.removeProperty(key);
            }
        } else {
            logger.warn((Object)("setProperty(key, value) ignored because of null key for object: " + value + "; please report the following stack trace to " + MuleManifest.getDevListEmail()), new Throwable());
        }
    }

    @Override
    public final String getPayloadAsString() throws Exception {
        this.assertAccess(false);
        return this.getPayloadAsString(this.getEncoding());
    }

    @Override
    public byte[] getPayloadAsBytes() throws Exception {
        this.assertAccess(false);
        if (this.cache != null) {
            return this.cache;
        }
        byte[] result = this.getPayload(byte[].class);
        if (this.muleContext.getConfiguration().isCacheMessageAsBytes()) {
            this.cache = result;
        }
        return result;
    }

    @Override
    public String getPayloadAsString(String encoding) throws Exception {
        this.assertAccess(false);
        if (this.cache != null) {
            return new String(this.cache, encoding);
        }
        String result = this.getPayload(String.class, encoding);
        if (this.muleContext.getConfiguration().isCacheMessageAsBytes()) {
            this.cache = result.getBytes(encoding);
        }
        return result;
    }

    @Override
    public Set<String> getPropertyNames() {
        this.assertAccess(false);
        return this.properties.getPropertyNames();
    }

    @Override
    public Set<String> getPropertyNames(PropertyScope scope) {
        this.assertAccess(false);
        return this.properties.getScopedProperties(scope).keySet();
    }

    @Override
    public double getDoubleProperty(String name, double defaultValue) {
        this.assertAccess(false);
        return this.properties.getDoubleProperty(name, defaultValue);
    }

    @Override
    public void setDoubleProperty(String name, double value) {
        this.assertAccess(true);
        this.setProperty(name, value);
    }

    @Override
    public String getUniqueId() {
        this.assertAccess(false);
        return this.id;
    }

    public void setUniqueId(String uid) {
        this.assertAccess(true);
        this.id = uid;
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        this.assertAccess(false);
        return this.properties.getProperty(name, defaultValue);
    }

    @Override
    public Object getProperty(String name, PropertyScope scope) {
        this.assertAccess(false);
        return this.properties.getProperty(name, scope);
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        this.assertAccess(false);
        return this.properties.getIntProperty(name, defaultValue);
    }

    @Override
    public long getLongProperty(String name, long defaultValue) {
        this.assertAccess(false);
        return this.properties.getLongProperty(name, defaultValue);
    }

    @Override
    public boolean getBooleanProperty(String name, boolean defaultValue) {
        this.assertAccess(false);
        return this.properties.getBooleanProperty(name, defaultValue);
    }

    @Override
    public void setBooleanProperty(String name, boolean value) {
        this.assertAccess(true);
        this.setProperty(name, value);
    }

    @Override
    public void setIntProperty(String name, int value) {
        this.assertAccess(true);
        this.setProperty(name, value);
    }

    @Override
    public void setLongProperty(String name, long value) {
        this.assertAccess(true);
        this.setProperty(name, value);
    }

    @Override
    public void setCorrelationId(String id) {
        this.assertAccess(true);
        if (StringUtils.isNotBlank((String)id)) {
            this.setProperty("MULE_CORRELATION_ID", id);
        } else {
            this.removeProperty("MULE_CORRELATION_ID");
        }
    }

    @Override
    public String getCorrelationId() {
        this.assertAccess(false);
        return (String)this.getProperty("MULE_CORRELATION_ID");
    }

    @Override
    public void setReplyTo(Object replyTo) {
        this.assertAccess(true);
        if (replyTo != null) {
            this.setProperty("MULE_REPLYTO", replyTo);
        } else {
            this.removeProperty("MULE_REPLYTO");
        }
    }

    @Override
    public Object getReplyTo() {
        this.assertAccess(false);
        return this.getProperty("MULE_REPLYTO");
    }

    @Override
    public int getCorrelationSequence() {
        this.assertAccess(false);
        return this.getIntProperty("MULE_CORRELATION_SEQUENCE", -1);
    }

    @Override
    public void setCorrelationSequence(int sequence) {
        this.assertAccess(true);
        this.setIntProperty("MULE_CORRELATION_SEQUENCE", sequence);
    }

    @Override
    public int getCorrelationGroupSize() {
        this.assertAccess(false);
        return this.getIntProperty("MULE_CORRELATION_GROUP_SIZE", -1);
    }

    @Override
    public void setCorrelationGroupSize(int size) {
        this.assertAccess(true);
        this.setIntProperty("MULE_CORRELATION_GROUP_SIZE", size);
    }

    @Override
    public ExceptionPayload getExceptionPayload() {
        this.assertAccess(false);
        return this.exceptionPayload;
    }

    @Override
    public void setExceptionPayload(ExceptionPayload exceptionPayload) {
        this.assertAccess(true);
        this.exceptionPayload = exceptionPayload;
    }

    public String toString() {
        this.assertAccess(false);
        StringBuffer buf = new StringBuffer(120);
        buf.append(this.getClass().getName());
        buf.append("{id=").append(this.getUniqueId());
        buf.append(", payload=").append(this.getPayload().getClass().getName());
        buf.append(", properties=").append(this.properties);
        buf.append(", correlationId=").append(this.getCorrelationId());
        buf.append(", correlationGroup=").append(this.getCorrelationGroupSize());
        buf.append(", correlationSeq=").append(this.getCorrelationSequence());
        buf.append(", encoding=").append(this.getEncoding());
        buf.append(", exceptionPayload=").append(this.exceptionPayload);
        if (logger.isDebugEnabled()) {
            buf.append(", properties=").append(this.properties);
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.assertAccess(true);
        this.attachments.put(name, dataHandler);
    }

    @Override
    public void removeAttachment(String name) throws Exception {
        this.assertAccess(true);
        this.attachments.remove(name);
    }

    @Override
    public DataHandler getAttachment(String name) {
        this.assertAccess(false);
        return this.attachments.get(name);
    }

    @Override
    public Set<String> getAttachmentNames() {
        this.assertAccess(false);
        return Collections.unmodifiableSet(this.attachments.keySet());
    }

    @Override
    public String getEncoding() {
        this.assertAccess(false);
        String encoding = this.getStringProperty("MULE_ENCODING", null);
        if (encoding != null) {
            return encoding;
        }
        return System.getProperty("mule.encoding");
    }

    @Override
    public void setEncoding(String encoding) {
        this.assertAccess(true);
        this.setStringProperty("MULE_ENCODING", encoding);
    }

    @Override
    public String getStringProperty(String name, String defaultValue) {
        this.assertAccess(false);
        return this.properties.getStringProperty(name, defaultValue);
    }

    @Override
    public void setStringProperty(String name, String value) {
        this.assertAccess(true);
        this.setProperty(name, value);
    }

    @Override
    public void addProperties(Map<String, Object> props) {
        this.addProperties(props, this.properties.getDefaultScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProperties(Map<String, Object> props, PropertyScope scope) {
        this.assertAccess(true);
        if (props != null) {
            Map<String, Object> map = props;
            synchronized (map) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    this.setProperty(entry.getKey(), entry.getValue(), scope);
                }
            }
        }
    }

    public void addInboundProperties(Map<String, Object> props) {
        this.properties.addInboundProperties(props);
    }

    @Override
    public void clearProperties() {
        this.assertAccess(true);
        this.properties.clearProperties();
    }

    @Override
    public Object getPayload() {
        return this.payload;
    }

    @Override
    public synchronized void setPayload(Object payload) {
        this.payload = payload == null ? NullPayload.getInstance() : payload;
        this.cache = null;
    }

    @Override
    public void release() {
        this.cache = null;
        this.appliedTransformerHashCodes.clear();
    }

    @Override
    public void applyTransformers(List<? extends Transformer> transformers) throws TransformerException {
        this.applyTransformers(transformers, null);
    }

    @Override
    public void applyTransformers(Transformer ... transformers) throws TransformerException {
        this.applyTransformers(Arrays.asList(transformers), null);
    }

    @Override
    public void applyTransformers(List<? extends Transformer> transformers, Class<?> outputType) throws TransformerException {
        if (!transformers.isEmpty() && !this.appliedTransformerHashCodes.contains(((Object)transformers).hashCode())) {
            this.applyAllTransformers(transformers);
            this.appliedTransformerHashCodes.add(((Object)transformers).hashCode());
        }
        if (null != outputType && !this.getPayload().getClass().isAssignableFrom(outputType)) {
            this.setPayload(this.getPayload(outputType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyAllTransformers(List<? extends Transformer> transformers) throws TransformerException {
        if (!transformers.isEmpty()) {
            for (Transformer transformer : transformers) {
                Class<?> srcCls;
                if (this.getPayload() == null) {
                    if (transformer.isAcceptNull()) {
                        this.setPayload(NullPayload.getInstance());
                    } else {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)("Transformer " + transformer + " doesn't support the null payload, exiting from transformer chain."));
                        break;
                    }
                }
                if (transformer.isSourceTypeSupported(srcCls = this.getPayload().getClass())) {
                    Object result = transformer.transform(this);
                    if (this.originalPayload == null && this.muleContext.getConfiguration().isCacheMessageOriginalPayload()) {
                        this.originalPayload = this.payload;
                    }
                    if (result instanceof MuleMessage) {
                        DefaultMuleMessage defaultMuleMessage = this;
                        synchronized (defaultMuleMessage) {
                            MuleMessage resultMessage = (MuleMessage)result;
                            this.setPayload(resultMessage.getPayload());
                            this.originalPayload = resultMessage.getOriginalPayload();
                            this.copyMessageProperties(resultMessage);
                            this.copyAttachments(resultMessage);
                            continue;
                        }
                    }
                    this.setPayload(result);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transformer " + transformer + " doesn't support the source payload: " + srcCls));
                }
                if (transformer.isIgnoreBadInput()) continue;
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)"Exiting from transformer chain (ignoreBadInput = false)");
                break;
            }
        }
    }

    @Override
    public ThreadSafeAccess newThreadCopy() {
        return new DefaultMuleMessage(this);
    }

    @Override
    public void resetAccessControl() {
        if (this.ownerThread != null) {
            this.ownerThread.set(null);
        }
        if (this.mutable != null) {
            this.mutable.set(true);
        }
    }

    @Override
    public void assertAccess(boolean write) {
        if (ThreadSafeAccess.AccessControl.isAssertMessageAccess()) {
            this.initAccessControl();
            this.setOwner();
            this.checkMutable(write);
        }
    }

    private synchronized void initAccessControl() {
        if (null == this.ownerThread) {
            this.ownerThread = new AtomicReference();
        }
        if (null == this.mutable) {
            this.mutable = new AtomicBoolean(true);
        }
    }

    private void setOwner() {
        if (null == this.ownerThread.get()) {
            this.ownerThread.compareAndSet(null, (Object)Thread.currentThread());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkMutable(boolean write) {
        Thread currentThread = Thread.currentThread();
        if (currentThread.equals(this.ownerThread.get())) {
            if (!write || this.mutable.get()) return;
            if (!this.isDisabled()) throw this.newException("Cannot write to immutable message");
            logger.warn((Object)"Writing to immutable message (exception disabled)");
            return;
        } else {
            if (!write) return;
            if (!this.isDisabled()) throw this.newException("Only owner thread can write to message: " + this.ownerThread.get() + "/" + Thread.currentThread());
            logger.warn((Object)"Non-owner writing to message (exception disabled)");
        }
    }

    protected boolean isDisabled() {
        return !ThreadSafeAccess.AccessControl.isFailOnMessageScribbling();
    }

    protected IllegalStateException newException(String message) {
        IllegalStateException exception = new IllegalStateException(message);
        logger.warn((Object)"Message access violation", (Throwable)exception);
        return exception;
    }

    public boolean isConsumable() {
        return this.isConsumedFromAdditional(this.getPayload().getClass());
    }

    public static MuleMessage copy(MuleMessage message) {
        if (message instanceof DefaultMuleMessage) {
            return new DefaultMuleMessage((DefaultMuleMessage)message);
        }
        throw new IllegalArgumentException("In order to clone a message it must be assignable from: " + DefaultMuleMessage.class.getName());
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        if (this.payload instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.payload);
        } else {
            out.writeBoolean(false);
            byte[] serializablePayload = this.getPayloadAsBytes();
            out.writeInt(serializablePayload.length);
            out.write(serializablePayload);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean payloadWasSerialized = in.readBoolean();
        if (payloadWasSerialized) {
            this.payload = in.readObject();
        } else {
            int payloadSize = in.readInt();
            byte[] serializedPayload = new byte[payloadSize];
            in.read(serializedPayload);
            this.payload = serializedPayload;
        }
    }

    void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
        this.muleContext = muleContext;
    }

    static {
        DefaultMuleMessage.addToConsuableClasses("javax.xml.stream.XMLStreamReader");
        DefaultMuleMessage.addToConsuableClasses("javax.xml.transform.stream.StreamSource");
        consumableClasses.add(OutputHandler.class);
    }
}

