/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.mule.AbstractExceptionListener;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.NullPayload;
import org.mule.util.ObjectUtils;

public class DefaultExceptionStrategy
extends AbstractExceptionListener {
    public void handleMessagingException(MuleMessage message, Throwable t) {
        this.defaultHandler(t);
        this.routeException(this.messageFromContextIfAvailable(message), null, t);
    }

    public void handleRoutingException(MuleMessage message, ImmutableEndpoint endpoint, Throwable t) {
        this.defaultHandler(t);
        this.routeException(this.messageFromContextIfAvailable(message), endpoint, t);
    }

    public void handleLifecycleException(Object component, Throwable t) {
        this.handleStandardException(t);
        this.logger.error((Object)("The object that failed was: \n" + ObjectUtils.toString((Object)component, (String)"null")));
    }

    public void handleStandardException(Throwable t) {
        this.handleTransaction(t);
        if (RequestContext.getEventContext() != null) {
            this.handleMessagingException(RequestContext.getEventContext().getMessage(), t);
        } else {
            this.logger.info((Object)"There is no current event available, routing Null message with the exception");
            this.handleMessagingException(new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext), t);
        }
    }

    protected void defaultHandler(Throwable t) {
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(new DefaultExceptionPayload(t));
        }
    }

    protected MuleMessage messageFromContextIfAvailable(MuleMessage message) {
        if (null != RequestContext.getEvent()) {
            return RequestContext.getEvent().getMessage();
        }
        return message;
    }
}

