/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.List;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.endpoint.OutboundEndpointDecorator;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.security.SecurityException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.context.notification.SecurityNotification;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnectable;

public abstract class AbstractMessageDispatcher
extends AbstractConnectable
implements MessageDispatcher {
    public AbstractMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    public final void initialise() throws InitialisationException {
        super.initialise();
        this.doInitialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        super.dispose();
        try {
            this.doDispose();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.disposed.set(true);
            throw throwable;
        }
        this.disposed.set(true);
    }

    public final void dispatch(MuleEvent event) throws DispatchException {
        event.setSynchronous(false);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
        ImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 401));
                this.handleException(e);
                return;
            }
            catch (Exception e) {
                this.handleException(e);
                return;
            }
        }
        try {
            if (endpoint instanceof OutboundEndpointDecorator && !((OutboundEndpointDecorator)((Object)endpoint)).onMessage(event.getMessage())) {
                return;
            }
            this.connect();
            this.doDispatch(event);
            if (this.connector.isEnableMessageEvents()) {
                String component = null;
                if (event.getService() != null) {
                    component = event.getService().getName();
                }
                this.connector.fireNotification(new EndpointMessageNotification(event.getMessage(), event.getEndpoint(), component, 802));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final MuleMessage send(MuleEvent event) throws DispatchException {
        if (this.isTransactionRollback()) {
            return event.getMessage();
        }
        event.setSynchronous(true);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().getUri().toString());
        event = OptimizedRequestContext.unsafeSetEvent(event);
        ImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 401));
                this.handleException(e);
                return event.getMessage();
            }
            catch (Exception e) {
                this.handleException(e);
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        try {
            if (endpoint instanceof OutboundEndpointDecorator && !((OutboundEndpointDecorator)((Object)endpoint)).onMessage(event.getMessage())) {
                return null;
            }
            this.connect();
            MuleMessage result = this.doSend(event);
            if (result != null) {
                List<String> responseProperties = ((OutboundEndpoint)endpoint).getResponseProperties();
                for (String propertyName : responseProperties) {
                    Object propertyValue = event.getMessage().getProperty(propertyName);
                    if (propertyValue == null) continue;
                    result.setProperty(propertyName, propertyValue);
                }
            }
            if (this.connector.isEnableMessageEvents()) {
                String component = null;
                if (event.getService() != null) {
                    component = event.getService().getName();
                }
                this.connector.fireNotification(new EndpointMessageNotification(event.getMessage(), event.getEndpoint(), component, 803));
            }
            return result;
        }
        catch (DispatchException e) {
            this.handleException(e);
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    @Deprecated
    protected boolean returnResponse(MuleEvent event) {
        return this.returnResponse(event, false);
    }

    protected boolean returnResponse(MuleEvent event, boolean doSend) {
        boolean remoteSync = false;
        if (event.getEndpoint().getConnector().isResponseEnabled()) {
            boolean bl = remoteSync = event.getEndpoint().isSynchronous() || doSend;
            if (remoteSync && event.getService() != null) {
                ResponseRouterCollection responseRouters = event.getService().getResponseRouter();
                remoteSync = responseRouters == null || !responseRouters.hasEndpoints();
            }
        }
        if (!remoteSync) {
            event.getMessage().removeProperty("MULE_REMOTE_SYNC");
        }
        return remoteSync;
    }

    protected boolean isTransactionRollback() {
        try {
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            if (tx != null && tx.isRollbackOnly()) {
                return true;
            }
        }
        catch (TransactionException e) {
            this.logger.warn((Object)e.getMessage());
        }
        return false;
    }

    protected WorkManager getWorkManager() {
        try {
            return this.connector.getDispatcherWorkManager();
        }
        catch (MuleException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    public OutboundEndpoint getEndpoint() {
        return (OutboundEndpoint)super.getEndpoint();
    }

    protected abstract void doDispatch(MuleEvent var1) throws Exception;

    protected abstract MuleMessage doSend(MuleEvent var1) throws Exception;
}

