/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.InputStream;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.store.DeserializationPostInitialisable;

public class ByteArrayToSerializable
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public ByteArrayToSerializable() {
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            Object result = src instanceof byte[] ? SerializationUtils.deserialize((byte[])((byte[])src)) : SerializationUtils.deserialize((InputStream)((InputStream)src));
            if (result instanceof DeserializationPostInitialisable) {
                DeserializationPostInitialisable.Implementation.init(result, this.muleContext);
            }
            return result;
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed("byte[]", "Object"), this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

