/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.binding;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.routing.InterfaceBinding;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.NullPayload;
import org.mule.util.StringMessageUtils;

public class BindingInvocationHandler
implements InvocationHandler {
    public static final String DEFAULT_METHOD_NAME_TOKEN = "default";
    protected static Log logger = LogFactory.getLog(BindingInvocationHandler.class);
    protected Map<String, InterfaceBinding> routers = new ConcurrentHashMap();
    protected MuleContext muleContext;

    public BindingInvocationHandler(InterfaceBinding router) {
        this.addRouterForInterface(router);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRouterForInterface(InterfaceBinding router) {
        if (router.getMethod() == null) {
            if (this.routers.size() != 0) throw new IllegalArgumentException(CoreMessages.mustSetMethodNamesOnBinding().getMessage());
            this.routers.put(DEFAULT_METHOD_NAME_TOKEN, router);
        } else {
            this.routers.put(router.getMethod(), router);
        }
        this.muleContext = router.getEndpoint().getConnector().getMuleContext();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return this.toString();
        }
        MuleMessage message = this.createMuleMessage(args);
        message.setProperty("method", method.getName(), PropertyScope.INVOCATION);
        InterfaceBinding router = this.routers.get(method.getName());
        if (router == null) {
            router = this.routers.get(DEFAULT_METHOD_NAME_TOKEN);
        }
        if (router == null) {
            throw new IllegalArgumentException(CoreMessages.cannotFindBindingForMethod(method.getName()).toString());
        }
        MuleEvent currentEvent = RequestContext.getEvent();
        MuleMessage reply = router.route(message, currentEvent.getSession());
        if (reply != null) {
            if (reply.getExceptionPayload() != null) {
                throw this.findDeclaredMethodException(method, reply.getExceptionPayload().getException());
            }
            return this.determineReply(reply, method);
        }
        return null;
    }

    private MuleMessage createMuleMessage(Object[] args) {
        if (args == null) {
            return new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext);
        }
        if (args.length == 1) {
            return new DefaultMuleMessage(args[0], this.muleContext);
        }
        return new DefaultMuleMessage(args, this.muleContext);
    }

    private Throwable findDeclaredMethodException(Method method, Throwable throwable) throws Throwable {
        Throwable cause = throwable.getCause();
        if (cause != null) {
            Class<?>[] exceptions = method.getExceptionTypes();
            for (int i = 0; i < exceptions.length; ++i) {
                if (!cause.getClass().equals(exceptions[i])) continue;
                return cause;
            }
        }
        return throwable;
    }

    private Object determineReply(MuleMessage reply, Method bindingMethod) {
        if (MuleMessage.class.isAssignableFrom(bindingMethod.getReturnType())) {
            return reply;
        }
        return reply.getPayload();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BindingInvocation");
        sb.append("{routers='").append(StringMessageUtils.toString(this.routers));
        sb.append('}');
        return sb.toString();
    }
}

