/*
 * Decompiled with CFR 0.152.
 */
package org.mule.object;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.config.i18n.CoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiObjectFactory
implements ObjectFactory {
    private boolean lookupOnEachCall = false;
    private String objectName;
    private String initialFactory;
    private String url;
    private Map properties;
    private Context _context;
    private Object _object;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public JndiObjectFactory() {
    }

    public JndiObjectFactory(String objectName, String initialFactory, String url) {
        this(objectName, initialFactory, url, null);
    }

    public JndiObjectFactory(String objectName, String initialFactory, String url, Map properties) {
        this.objectName = objectName;
        this.initialFactory = initialFactory;
        this.url = url;
        this.properties = properties;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this._context == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.initialFactory != null) {
                props.put("java.naming.factory.initial", this.initialFactory);
            } else if (this.properties == null || !this.properties.containsKey("java.naming.factory.initial")) {
                throw new InitialisationException(CoreMessages.objectIsNull("jndiInitialFactory"), (Initialisable)this);
            }
            if (this.url != null) {
                props.put("java.naming.provider.url", this.url);
            }
            if (this.properties != null) {
                props.putAll(this.properties);
            }
            try {
                this._context = new InitialContext(props);
            }
            catch (NamingException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this._context != null) {
            try {
                try {
                    this._context.close();
                }
                catch (NamingException e) {
                    this.logger.error((Object)"JNDI Context failed to dispose properly: ", (Throwable)e);
                    Object var3_2 = null;
                    this._context = null;
                }
                Object var3_1 = null;
                this._context = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._context = null;
                throw throwable;
            }
        }
    }

    @Override
    public Object getInstance() throws Exception {
        if (this._object == null || this.lookupOnEachCall) {
            this._object = this._context.lookup(this.objectName);
        }
        return this._object;
    }

    @Override
    public Class<?> getObjectClass() {
        throw new UnsupportedOperationException();
    }

    public String getInitialFactory() {
        return this.initialFactory;
    }

    public void setInitialFactory(String initialFactory) {
        this.initialFactory = initialFactory;
    }

    public boolean isLookupOnEachCall() {
        return this.lookupOnEachCall;
    }

    public void setLookupOnEachCall(boolean lookupOnEachCall) {
        this.lookupOnEachCall = lookupOnEachCall;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Context getContext() {
        return this._context;
    }

    protected void setContext(Context context) {
        this._context = context;
    }

    @Override
    public void addObjectInitialisationCallback(InitialisationCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public boolean isExternallyManagedLifecycle() {
        return false;
    }

    @Override
    public boolean isAutoWireObject() {
        return true;
    }
}

