/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.config.ImmutableThreadingProfile;
import org.mule.config.pool.ThreadPoolFactory;

public class MutableThreadingProfile
implements ThreadingProfile {
    private int maxThreadsActive;
    private int maxThreadsIdle;
    private int maxBufferSize;
    private long threadTTL;
    private long threadWaitTimeout;
    private int poolExhaustedAction;
    private boolean doThreading;
    private ThreadPoolFactory poolFactory;
    private ThreadingProfile.WorkManagerFactory workManagerFactory;
    private RejectedExecutionHandler rejectedExecutionHandler;
    private ThreadFactory threadFactory;
    private MuleContext muleContext;

    public MutableThreadingProfile(ThreadingProfile tp) {
        this.maxThreadsActive = tp.getMaxThreadsActive();
        this.maxThreadsIdle = tp.getMaxThreadsIdle();
        this.maxBufferSize = tp.getMaxBufferSize();
        this.threadTTL = tp.getThreadTTL();
        this.threadWaitTimeout = tp.getThreadWaitTimeout();
        this.poolExhaustedAction = tp.getPoolExhaustedAction();
        this.doThreading = tp.isDoThreading();
        this.rejectedExecutionHandler = tp.getRejectedExecutionHandler();
        this.threadFactory = tp.getThreadFactory();
        this.workManagerFactory = tp.getWorkManagerFactory();
        this.poolFactory = tp.getPoolFactory();
    }

    public ExecutorService createPool() {
        return this.createPool(null);
    }

    public int getMaxThreadsActive() {
        return this.maxThreadsActive;
    }

    public int getMaxThreadsIdle() {
        return this.maxThreadsIdle;
    }

    public long getThreadTTL() {
        return this.threadTTL;
    }

    public long getThreadWaitTimeout() {
        return this.threadWaitTimeout;
    }

    public int getPoolExhaustedAction() {
        return this.poolExhaustedAction;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setMaxThreadsActive(int maxThreadsActive) {
        this.maxThreadsActive = maxThreadsActive;
    }

    public void setMaxThreadsIdle(int maxThreadsIdle) {
        this.maxThreadsIdle = maxThreadsIdle;
    }

    public void setThreadTTL(long threadTTL) {
        this.threadTTL = threadTTL;
    }

    public void setThreadWaitTimeout(long threadWaitTimeout) {
        this.threadWaitTimeout = threadWaitTimeout;
    }

    public void setPoolExhaustedAction(int poolExhaustedAction) {
        this.poolExhaustedAction = poolExhaustedAction;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public ThreadingProfile.WorkManagerFactory getWorkManagerFactory() {
        return this.workManagerFactory;
    }

    public void setWorkManagerFactory(ThreadingProfile.WorkManagerFactory workManagerFactory) {
        this.workManagerFactory = workManagerFactory;
    }

    public WorkManager createWorkManager(String name, int shutdownTimeout) {
        return this.workManagerFactory.createWorkManager(new ImmutableThreadingProfile(this), name, shutdownTimeout);
    }

    public ExecutorService createPool(String name) {
        return this.poolFactory.createPool(name, new ImmutableThreadingProfile(this));
    }

    public boolean isDoThreading() {
        return this.doThreading;
    }

    public void setDoThreading(boolean doThreading) {
        this.doThreading = doThreading;
    }

    public ThreadPoolFactory getPoolFactory() {
        return this.poolFactory;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }
}

