/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.FatalException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.FileUtils;
import org.mule.util.NumberUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

public class DefaultMuleConfiguration
implements MuleConfiguration,
MuleContextAware {
    private boolean synchronous = false;
    private String systemModelType = "seda";
    private String encoding = "UTF-8";
    private int responseTimeout = 10000;
    private int defaultTransactionTimeout = 30000;
    private int defaultQueueTimeout = 200;
    private int shutdownTimeout = 5000;
    private String workingDirectory = "./.mule";
    private boolean clientMode = false;
    private String id;
    private String clusterId;
    private String domainId;
    private boolean cacheMessageAsBytes = true;
    private boolean cacheMessageOriginalPayload = true;
    private boolean enableStreaming = true;
    private boolean autoWrapMessageAwareTransform = true;
    protected transient Log logger = LogFactory.getLog(DefaultMuleConfiguration.class);
    private MuleContext muleContext;

    public DefaultMuleConfiguration() {
        this.applySystemProperties();
        if (this.id == null) {
            this.id = UUID.getUUID();
        }
        if (this.clusterId == null) {
            this.clusterId = CoreMessages.notClustered().getMessage();
        }
        if (this.domainId == null) {
            try {
                this.domainId = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.logger.warn((Object)e);
                this.domainId = "org.mule";
            }
        }
        try {
            this.validateEncoding();
            this.validateXML();
        }
        catch (FatalException e) {
            throw new RuntimeException(e);
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected void applySystemProperties() {
        String p = System.getProperty("mule.encoding");
        if (p != null) {
            this.encoding = p;
        } else {
            System.setProperty("mule.encoding", this.encoding);
        }
        p = System.getProperty("mule.endpoints.synchronous");
        if (p != null) {
            this.synchronous = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.systemModelType")) != null) {
            this.systemModelType = p;
        }
        if ((p = System.getProperty("mule.timeout.synchronous")) != null) {
            this.responseTimeout = NumberUtils.toInt(p);
        }
        if ((p = System.getProperty("mule.timeout.transaction")) != null) {
            this.defaultTransactionTimeout = NumberUtils.toInt(p);
        }
        if ((p = System.getProperty("mule.workingDirectory")) != null) {
            this.workingDirectory = p;
        }
        if ((p = System.getProperty("mule.clientMode")) != null) {
            this.clientMode = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.serverId")) != null) {
            this.id = p;
        }
        if ((p = System.getProperty("mule.clusterId")) != null) {
            this.clusterId = p;
        }
        if ((p = System.getProperty("mule.domainId")) != null) {
            this.domainId = p;
        }
        if ((p = System.getProperty("mule.message.cacheBytes")) != null) {
            this.cacheMessageAsBytes = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.message.cacheOriginal")) != null) {
            this.cacheMessageOriginalPayload = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.streaming.enable")) != null) {
            this.enableStreaming = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.transform.autoWrap")) != null) {
            this.autoWrapMessageAwareTransform = BooleanUtils.toBoolean((String)p);
        }
    }

    protected void validateEncoding() throws FatalException {
        if (!Charset.isSupported(this.encoding)) {
            throw new FatalException(CoreMessages.propertyHasInvalidValue("encoding", this.encoding), (Object)this);
        }
    }

    protected void validateXML() throws FatalException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        if (f == null || f.getClass().getName().indexOf("crimson") != -1) {
            throw new FatalException(CoreMessages.valueIsInvalidFor(f.getClass().getName(), "javax.xml.parsers.SAXParserFactory"), (Object)this);
        }
    }

    public boolean isDefaultSynchronousEndpoints() {
        return this.synchronous;
    }

    public void setDefaultSynchronousEndpoints(boolean synchronous) {
        if (this.verifyContextNotStarted()) {
            this.synchronous = synchronous;
        }
    }

    public int getDefaultResponseTimeout() {
        return this.responseTimeout;
    }

    public void setDefaultResponseTimeout(int responseTimeout) {
        if (this.verifyContextNotStarted()) {
            this.responseTimeout = responseTimeout;
        }
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getMuleHomeDirectory() {
        return System.getProperty("mule.home");
    }

    public void setWorkingDirectory(String workingDirectory) {
        if (this.verifyContextNotInitialized()) {
            this.workingDirectory = FileUtils.newFile(workingDirectory).getAbsolutePath().replaceAll("\\\\", "/");
        }
    }

    public int getDefaultTransactionTimeout() {
        return this.defaultTransactionTimeout;
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        if (this.verifyContextNotStarted()) {
            this.defaultTransactionTimeout = defaultTransactionTimeout;
        }
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public String getDefaultEncoding() {
        return this.encoding;
    }

    public void setDefaultEncoding(String encoding) {
        if (this.verifyContextNotInitialized()) {
            this.encoding = encoding;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.verifyContextNotInitialized()) {
            if (StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("Cannot set server id to null/blank");
            }
            this.id = id;
        }
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        if (this.verifyContextNotInitialized()) {
            this.clusterId = clusterId;
        }
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        if (this.verifyContextNotInitialized()) {
            this.domainId = domainId;
        }
    }

    public String getSystemModelType() {
        return this.systemModelType;
    }

    public void setSystemModelType(String systemModelType) {
        if (this.verifyContextNotStarted()) {
            this.systemModelType = systemModelType;
        }
    }

    public void setClientMode(boolean clientMode) {
        if (this.verifyContextNotStarted()) {
            this.clientMode = clientMode;
        }
    }

    public String getSystemName() {
        return this.domainId + "." + this.clusterId + "." + this.id;
    }

    public boolean isAutoWrapMessageAwareTransform() {
        return this.autoWrapMessageAwareTransform;
    }

    public void setAutoWrapMessageAwareTransform(boolean autoWrapMessageAwareTransform) {
        if (this.verifyContextNotStarted()) {
            this.autoWrapMessageAwareTransform = autoWrapMessageAwareTransform;
        }
    }

    public boolean isCacheMessageAsBytes() {
        return this.cacheMessageAsBytes;
    }

    public void setCacheMessageAsBytes(boolean cacheMessageAsBytes) {
        if (this.verifyContextNotStarted()) {
            this.cacheMessageAsBytes = cacheMessageAsBytes;
        }
    }

    public boolean isCacheMessageOriginalPayload() {
        return this.cacheMessageOriginalPayload;
    }

    public void setCacheMessageOriginalPayload(boolean cacheMessageOriginalPayload) {
        if (this.verifyContextNotStarted()) {
            this.cacheMessageOriginalPayload = cacheMessageOriginalPayload;
        }
    }

    public boolean isEnableStreaming() {
        return this.enableStreaming;
    }

    public void setEnableStreaming(boolean enableStreaming) {
        if (this.verifyContextNotStarted()) {
            this.enableStreaming = enableStreaming;
        }
    }

    protected boolean verifyContextNotInitialized() {
        if (this.muleContext != null && this.muleContext.getLifecycleManager().isPhaseComplete("initialise")) {
            this.logger.warn((Object)"Cannot modify MuleConfiguration once the MuleContext has been initialized.  Modification will be ignored.");
            return false;
        }
        return true;
    }

    protected boolean verifyContextNotStarted() {
        if (this.muleContext != null && this.muleContext.getLifecycleManager().isPhaseComplete("start")) {
            this.logger.warn((Object)"Cannot modify MuleConfiguration once the MuleContext has been started.  Modification will be ignored.");
            return false;
        }
        return true;
    }

    public int getDefaultQueueTimeout() {
        return this.defaultQueueTimeout;
    }

    public void setDefaultQueueTimeout(int defaultQueueTimeout) {
        if (this.verifyContextNotStarted()) {
            this.defaultQueueTimeout = defaultQueueTimeout;
        }
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        if (this.verifyContextNotStarted()) {
            this.shutdownTimeout = shutdownTimeout;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.autoWrapMessageAwareTransform ? 1231 : 1237);
        result = 31 * result + (this.cacheMessageAsBytes ? 1231 : 1237);
        result = 31 * result + (this.cacheMessageOriginalPayload ? 1231 : 1237);
        result = 31 * result + (this.clientMode ? 1231 : 1237);
        result = 31 * result + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        result = 31 * result + this.defaultQueueTimeout;
        result = 31 * result + this.defaultTransactionTimeout;
        result = 31 * result + (this.domainId == null ? 0 : this.domainId.hashCode());
        result = 31 * result + (this.enableStreaming ? 1231 : 1237);
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.responseTimeout;
        result = 31 * result + this.shutdownTimeout;
        result = 31 * result + (this.synchronous ? 1231 : 1237);
        result = 31 * result + (this.systemModelType == null ? 0 : this.systemModelType.hashCode());
        result = 31 * result + (this.workingDirectory == null ? 0 : this.workingDirectory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultMuleConfiguration other = (DefaultMuleConfiguration)obj;
        if (this.autoWrapMessageAwareTransform != other.autoWrapMessageAwareTransform) {
            return false;
        }
        if (this.cacheMessageAsBytes != other.cacheMessageAsBytes) {
            return false;
        }
        if (this.cacheMessageOriginalPayload != other.cacheMessageOriginalPayload) {
            return false;
        }
        if (this.clientMode != other.clientMode) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.defaultQueueTimeout != other.defaultQueueTimeout) {
            return false;
        }
        if (this.defaultTransactionTimeout != other.defaultTransactionTimeout) {
            return false;
        }
        if (this.domainId == null ? other.domainId != null : !this.domainId.equals(other.domainId)) {
            return false;
        }
        if (this.enableStreaming != other.enableStreaming) {
            return false;
        }
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.responseTimeout != other.responseTimeout) {
            return false;
        }
        if (this.shutdownTimeout != other.shutdownTimeout) {
            return false;
        }
        if (this.synchronous != other.synchronous) {
            return false;
        }
        if (this.systemModelType == null ? other.systemModelType != null : !this.systemModelType.equals(other.systemModelType)) {
            return false;
        }
        return !(this.workingDirectory == null ? other.workingDirectory != null : !this.workingDirectory.equals(other.workingDirectory));
    }
}

