/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.registry;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.registry.AbstractServiceDescriptor;
import org.mule.api.registry.ServiceDescriptor;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceFinder;
import org.mule.api.registry.ServiceType;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.DefaultModelServiceDescriptor;
import org.mule.transport.service.DefaultTransportServiceDescriptor;
import org.mule.transport.service.MetaTransportServiceDescriptor;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.ClassUtils;
import org.mule.util.SpiUtils;

public class ServiceDescriptorFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public static ServiceDescriptor create(ServiceType type, String name, Properties props, Properties overrides, MuleContext muleContext, ClassLoader classLoader) throws ServiceException {
        AbstractServiceDescriptor sd;
        if (overrides != null) {
            props.putAll((Map<?, ?>)overrides);
        }
        String scheme = name;
        String metaScheme = null;
        int i = name.indexOf(":");
        if (i > -1) {
            scheme = name.substring(i + 1);
            metaScheme = name.substring(0, i);
        }
        if ("axis".equals(metaScheme) || "wsdl-axis".equals(metaScheme) || "cxf".equals(metaScheme) || "wsdl-cxf".equals(metaScheme) || "jms".equals(metaScheme) || "wmq".equals(metaScheme) || "ajax".equals(metaScheme)) {
            metaScheme = null;
        } else if (name.startsWith("jetty:http")) {
            scheme = "jetty";
        }
        String serviceFinderClass = (String)props.remove("service.finder");
        if (type.equals((Object)ServiceType.TRANSPORT)) {
            try {
                sd = metaScheme != null ? new MetaTransportServiceDescriptor(metaScheme, scheme, props, classLoader) : new DefaultTransportServiceDescriptor(scheme, props, classLoader);
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServiceException(CoreMessages.failedToCreate("Transport: " + name));
            }
            Properties exceptionMappingProps = SpiUtils.findServiceDescriptor(ServiceType.EXCEPTION, name + "-exception-mappings");
            ((TransportServiceDescriptor)((Object)sd)).setExceptionMappings(exceptionMappingProps);
        } else if (type.equals((Object)ServiceType.MODEL)) {
            sd = new DefaultModelServiceDescriptor(name, props);
        } else {
            throw new ServiceException(CoreMessages.unrecognisedServiceType(type));
        }
        if (StringUtils.isNotBlank((String)serviceFinderClass)) {
            ServiceFinder finder;
            try {
                finder = (ServiceFinder)ClassUtils.instanciateClass(serviceFinderClass, new Object[0]);
            }
            catch (Exception e) {
                throw new ServiceException(CoreMessages.cannotInstanciateFinder(serviceFinderClass), (Throwable)e);
            }
            String realService = finder.findService(name, sd, props);
            if (realService != null) {
                return muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, realService, overrides);
            }
            throw new ServiceException(CoreMessages.serviceFinderCantFindService(name));
        }
        return sd;
    }
}

