/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ExceptionHelper;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.scan.ClassScanner;
import org.mule.util.scan.ImplementationClassScanner;
import org.mule.util.scan.InterfaceClassScanner;
import org.mule.util.scan.annotations.AnnotationFilter;
import org.mule.util.scan.annotations.AnnotationTypeFilter;
import org.mule.util.scan.annotations.AnnotationsScanner;
import org.mule.util.scan.annotations.MetaAnnotationTypeFilter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathScanner {
    protected final transient Log logger = LogFactory.getLog(ClasspathScanner.class);
    private ClassLoader classLoader;
    private String[] basepaths = new String[]{""};

    public ClasspathScanner(String ... basepaths) {
        this.classLoader = this.getClass().getClassLoader();
        this.basepaths = basepaths;
    }

    public ClasspathScanner(ClassLoader classLoader, String ... basepaths) {
        this.classLoader = classLoader;
        this.basepaths = basepaths;
    }

    public Set<Class> scanFor(Class clazz) throws IOException {
        HashSet<Class> classes = new HashSet<Class>();
        for (int i = 0; i < this.basepaths.length; ++i) {
            String basepath = this.basepaths[i];
            Enumeration<URL> urls = this.classLoader.getResources(basepath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url.getProtocol().equalsIgnoreCase("file")) {
                    classes.addAll(this.processFileUrl(url, basepath, clazz));
                    continue;
                }
                if (url.getProtocol().equalsIgnoreCase("jar")) {
                    classes.addAll(this.processJarUrl(url, basepath, clazz));
                    continue;
                }
                throw new IllegalArgumentException("Do not understand how to handle protocol: " + url.getProtocol());
            }
        }
        return classes;
    }

    protected Set<Class> processJarUrl(URL url, String basepath, Class clazz) throws IOException {
        HashSet<Class> set = new HashSet<Class>();
        String path = url.getFile().substring(5, url.getFile().indexOf("!"));
        JarFile jar = new JarFile(path);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(basepath) || !entry.getName().endsWith(".class")) continue;
            try {
                Class c;
                String name = entry.getName();
                if (name.contains("$1")) continue;
                ClassReader reader = new ClassReader(this.classLoader.getResourceAsStream(name));
                ClassScanner visitor = this.getScanner(clazz);
                reader.accept((ClassVisitor)visitor, 0);
                if (!visitor.isMatch() || (c = this.loadClass(visitor.getClassName())) == null) continue;
                set.add(c);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) continue;
                Throwable t = ExceptionHelper.getRootException(e);
                this.logger.debug((Object)String.format("%s: caused by: %s", e.toString(), t.toString()));
            }
        }
        return set;
    }

    protected Set<Class> processFileUrl(URL url, String basepath, Class clazz) throws IOException {
        HashSet<Class> set = new HashSet<Class>();
        String urlBase = url.getFile();
        Collection files = FileUtils.listFiles((File)new File(url.getFile()), (String[])new String[]{"class"}, (boolean)true);
        String name = null;
        for (File file : files) {
            try {
                Class c;
                name = file.getAbsolutePath().substring(urlBase.length() - basepath.length());
                name = name.replaceAll("/", ".");
                if (name.endsWith(".class")) {
                    name = name.substring(0, name.length() - 6);
                }
                ClassReader reader = new ClassReader(name);
                ClassScanner visitor = this.getScanner(clazz);
                reader.accept((ClassVisitor)visitor, 0);
                if (!visitor.isMatch() || (c = this.loadClass(visitor.getClassName())) == null) continue;
                set.add(c);
            }
            catch (IOException e) {
                if (!this.logger.isDebugEnabled()) continue;
                Throwable t = ExceptionHelper.getRootException(e);
                this.logger.debug((Object)String.format("%s: caused by: %s", e.toString(), t.toString()));
            }
        }
        return set;
    }

    protected Class loadClass(String name) {
        String c = name.replace("/", ".");
        try {
            return ClassUtils.loadClass(c, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)String.format("%s : %s", c, e.toString()));
            }
            return null;
        }
    }

    protected ClassScanner getScanner(Class clazz) {
        if (clazz.isInterface()) {
            if (clazz.isAnnotation()) {
                AnnotationFilter filter = null;
                Annotation[] annos = clazz.getDeclaredAnnotations();
                for (int i = 0; i < annos.length; ++i) {
                    Annotation anno = annos[i];
                    if (!(anno instanceof Target) || ((Target)anno).value()[0] != ElementType.ANNOTATION_TYPE) continue;
                    filter = new MetaAnnotationTypeFilter(clazz);
                }
                if (filter == null) {
                    filter = new AnnotationTypeFilter(clazz);
                }
                return new AnnotationsScanner(filter);
            }
            return new InterfaceClassScanner(clazz);
        }
        return new ImplementationClassScanner(clazz);
    }
}

