/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.util.FileUtils;
import org.mule.util.UUID;
import org.mule.util.file.DeleteException;
import org.mule.util.queue.QueuePersistenceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePersistenceStrategy
implements QueuePersistenceStrategy,
MuleContextAware {
    private static final Log logger = LogFactory.getLog(FilePersistenceStrategy.class);
    public static final String DEFAULT_QUEUE_STORE = "queuestore";
    public static final String EXTENSION = ".msg";
    private File store;
    protected MuleContext muleContext;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected String getId(Object obj) {
        return UUID.getUUID();
    }

    @Override
    public Object store(String queue, Object obj) throws IOException {
        String id = this.getId(obj);
        File file = FileUtils.newFile(this.store, queue + File.separator + id + EXTENSION);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("Failed to create directory: " + file.getAbsolutePath());
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        oos.writeObject(obj);
        oos.close();
        return id;
    }

    @Override
    public void remove(String queue, Object id) throws IOException {
        File file = FileUtils.newFile(this.store, queue + File.separator + id + EXTENSION);
        if (file.exists()) {
            if (!file.delete()) {
                throw new DeleteException(file);
            }
        } else {
            throw new FileNotFoundException(file.toString());
        }
    }

    @Override
    public Object load(String queue, Object id) throws IOException {
        Object object;
        block4: {
            File file = FileUtils.newFile(this.store, queue + File.separator + id + EXTENSION);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new FileInputStream(file));
                object = ois.readObject();
                Object var7_7 = null;
                if (ois == null) break block4;
            }
            catch (ClassNotFoundException e) {
                try {
                    throw (IOException)new IOException("Error loading persistent object").initCause(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var7_8 = null;
                        if (ois == null) break block5;
                        ois.close();
                    }
                    throw throwable;
                }
            }
            ois.close();
        }
        return object;
    }

    @Override
    public List<QueuePersistenceStrategy.Holder> restore() throws IOException {
        ArrayList<QueuePersistenceStrategy.Holder> msgs = new ArrayList<QueuePersistenceStrategy.Holder>();
        if (this.store == null) {
            logger.warn((Object)"No store has be set on the File Persistence Strategy. Not restoring at this time");
            return msgs;
        }
        try {
            this.restoreFiles(this.store, msgs);
            logger.debug((Object)("Restore retrieved " + msgs.size() + " objects"));
            return msgs;
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("Could not restore").initCause(e);
        }
    }

    protected void restoreFiles(File dir, List<QueuePersistenceStrategy.Holder> msgs) throws IOException, ClassNotFoundException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.restoreFiles(files[i], msgs);
                continue;
            }
            if (!files[i].getName().endsWith(EXTENSION)) continue;
            String id = files[i].getCanonicalPath();
            id = id.substring(this.store.getCanonicalPath().length() + 1, id.length() - EXTENSION.length());
            String queue = id.substring(0, id.indexOf(File.separator));
            id = id.substring(queue.length() + 1);
            msgs.add(new HolderImpl(queue, id));
        }
    }

    @Override
    public void open() throws IOException {
        String path = this.muleContext.getConfiguration().getWorkingDirectory() + File.separator + DEFAULT_QUEUE_STORE;
        this.store = FileUtils.newFile(path).getCanonicalFile();
        if (!this.store.exists() && !this.store.mkdirs()) {
            throw new IOException("Failed to create directory: " + this.store.getAbsolutePath());
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    protected static class HolderImpl
    implements QueuePersistenceStrategy.Holder {
        private String queue;
        private Object id;

        public HolderImpl(String queue, Object id) {
            this.queue = queue;
            this.id = id;
        }

        public Object getId() {
            return this.id;
        }

        public String getQueue() {
            return this.queue;
        }
    }
}

