/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ExceptionHelper;
import org.mule.transport.service.TransportFactory;
import org.mule.util.IOUtils;

public class SpiUtils {
    private static final Log logger = LogFactory.getLog(SpiUtils.class);
    public static final String SERVICE_ROOT = "META-INF/services/";
    @Deprecated
    public static final String PROVIDER_SERVICE_PATH = "org/mule/providers/";
    public static final String TRANSPORT_SERVICE_PATH = "org/mule/transport/";
    public static final String EXCEPTION_SERVICE_PATH = "org/mule/config/";

    public static Properties findServiceDescriptor(String type, String name) {
        if (type.equals("transport")) {
            Properties tsd = SpiUtils.findServiceDescriptor(TRANSPORT_SERVICE_PATH, name, TransportFactory.class, false);
            if (tsd == null && (tsd = SpiUtils.findServiceDescriptor(PROVIDER_SERVICE_PATH, name, TransportFactory.class, false)) != null) {
                SpiUtils.logTsdDeprecationWarning(name);
            }
            if (tsd == null && (tsd = SpiUtils.findServiceDescriptor(TRANSPORT_SERVICE_PATH, name, TransportFactory.class)) == null && (tsd = SpiUtils.findServiceDescriptor(PROVIDER_SERVICE_PATH, name, TransportFactory.class)) != null) {
                SpiUtils.logTsdDeprecationWarning(name);
            }
            return tsd;
        }
        if (type.equals("exception")) {
            return SpiUtils.findServiceDescriptor(EXCEPTION_SERVICE_PATH, name, ExceptionHelper.class);
        }
        logger.warn((Object)("Attempt to lookup unrecognized service type: " + type));
        return null;
    }

    public static Properties findServiceDescriptor(String path, String name, Class currentClass) {
        return SpiUtils.findServiceDescriptor(path, name, currentClass, true);
    }

    public static Properties findServiceDescriptor(String path, String name, Class currentClass, boolean fallbackToNonPreferred) {
        String preferredName = null;
        String preferredPath = null;
        if (!name.endsWith(".properties")) {
            name = name + ".properties";
            preferredName = "preferred-" + name;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (path.startsWith(SERVICE_ROOT)) {
            path = path + name;
        } else {
            preferredPath = SERVICE_ROOT + path + preferredName;
            path = SERVICE_ROOT + path + name;
        }
        try {
            InputStream is = IOUtils.getResourceAsStream(preferredPath, currentClass, false, false);
            if (is == null && fallbackToNonPreferred) {
                is = IOUtils.getResourceAsStream(path, currentClass, false, false);
            }
            if (is != null) {
                Properties props = new Properties();
                try {
                    props.load(is);
                    return props;
                }
                catch (IOException e) {
                    logger.warn((Object)("Descriptor found but unable to load properties for service " + name));
                    return null;
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static void logTsdDeprecationWarning(String transport) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)MessageFormat.format("[{0}] transport service descriptor must be moved under {1}{2} Old-style {1}{3} has been deprecated and may not be supported in the future.", transport, SERVICE_ROOT, TRANSPORT_SERVICE_PATH, PROVIDER_SERVICE_PATH));
        }
    }
}

