/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.FileUtils;

public final class JarUtils {
    private static final String MULE_MODULE_FILENAME = "lib" + File.separator + "module";
    private static final String MULE_LIB_FILENAME = "lib" + File.separator + "mule";
    private static final String MULE_HOME = System.getProperty("mule.home");
    public static final String MULE_LOCAL_JAR_FILENAME = "mule-local-install.jar";
    private static final Log logger = LogFactory.getLog(JarUtils.class);

    private JarUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinkedHashMap readJarFileEntries(File jarFile) throws Exception {
        LinkedHashMap<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
        JarFile jarFileWrapper = null;
        if (jarFile == null) return entries;
        logger.debug((Object)("Reading jar entries from " + jarFile.getAbsolutePath()));
        try {
            jarFileWrapper = new JarFile(jarFile);
            Enumeration<JarEntry> iter = jarFileWrapper.entries();
            while (iter.hasMoreElements()) {
                Object var8_7;
                ZipEntry zipEntry = iter.nextElement();
                InputStream entryStream = jarFileWrapper.getInputStream(zipEntry);
                ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)entryStream, (OutputStream)byteArrayStream);
                    entries.put(zipEntry.getName(), byteArrayStream.toByteArray());
                    logger.debug((Object)("Read jar entry " + zipEntry.getName() + " from " + jarFile.getAbsolutePath()));
                    var8_7 = null;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    byteArrayStream.close();
                    throw throwable;
                }
                byteArrayStream.close();
                {
                }
            }
            Object var10_9 = null;
            if (jarFileWrapper == null) return entries;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (jarFileWrapper == null) throw throwable;
            try {
                jarFileWrapper.close();
                throw throwable;
            }
            catch (Exception ignore) {
                logger.debug((Object)ignore);
            }
            throw throwable;
        }
        try {
            jarFileWrapper.close();
            return entries;
        }
        catch (Exception ignore) {
            logger.debug((Object)ignore);
        }
        return entries;
    }

    public static void appendJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        if (entries != null) {
            LinkedHashMap combinedEntries = JarUtils.readJarFileEntries(jarFile);
            combinedEntries.putAll(entries);
            File tmpJarFile = File.createTempFile(jarFile.getName(), null);
            JarUtils.createJarFileEntries(tmpJarFile, combinedEntries);
            jarFile.delete();
            FileUtils.renameFile(tmpJarFile, jarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        JarOutputStream jarStream = null;
        FileOutputStream fileStream = null;
        if (jarFile != null) {
            block16: {
                logger.debug((Object)("Creating jar file " + jarFile.getAbsolutePath()));
                try {
                    fileStream = new FileOutputStream(jarFile);
                    jarStream = new JarOutputStream(fileStream);
                    if (entries != null && !entries.isEmpty()) {
                        for (String jarFilePath : entries.keySet()) {
                            Object content = entries.get(jarFilePath);
                            JarEntry entry = new JarEntry(jarFilePath);
                            jarStream.putNextEntry(entry);
                            logger.debug((Object)("Adding jar entry " + jarFilePath + " to " + jarFile.getAbsolutePath()));
                            if (content instanceof String) {
                                JarUtils.writeJarEntry((OutputStream)jarStream, ((String)content).getBytes());
                                continue;
                            }
                            if (content instanceof byte[]) {
                                JarUtils.writeJarEntry((OutputStream)jarStream, (byte[])content);
                                continue;
                            }
                            if (!(content instanceof File)) continue;
                            JarUtils.writeJarEntry((OutputStream)jarStream, (File)content);
                        }
                    }
                    jarStream.flush();
                    fileStream.getFD().sync();
                    Object var9_8 = null;
                    if (jarStream == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (jarStream != null) {
                        try {
                            jarStream.close();
                        }
                        catch (Exception jarNotClosed) {
                            logger.debug((Object)jarNotClosed);
                        }
                    }
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Exception fileNotClosed) {
                            logger.debug((Object)fileNotClosed);
                        }
                    }
                    throw throwable;
                }
                try {
                    jarStream.close();
                }
                catch (Exception jarNotClosed) {
                    logger.debug((Object)jarNotClosed);
                }
            }
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (Exception fileNotClosed) {
                    logger.debug((Object)fileNotClosed);
                }
            }
        }
    }

    private static void writeJarEntry(OutputStream stream, byte[] entry) throws IOException {
        stream.write(entry, 0, entry.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeJarEntry(OutputStream stream, File entry) throws IOException {
        FileInputStream fileContentStream = null;
        try {
            fileContentStream = new FileInputStream(entry);
            IOUtils.copy((InputStream)fileContentStream, (OutputStream)stream);
            Object var4_3 = null;
            if (fileContentStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileContentStream == null) throw throwable;
            try {
                fileContentStream.close();
                throw throwable;
            }
            catch (Exception fileContentNotClosed) {
                logger.debug((Object)fileContentNotClosed);
            }
            throw throwable;
        }
        try {
            fileContentStream.close();
            return;
        }
        catch (Exception fileContentNotClosed) {
            logger.debug((Object)fileContentNotClosed);
        }
    }

    public static File getMuleHomeFile() {
        return new File(MULE_HOME);
    }

    public static File getMuleLibDir() {
        return new File(MULE_HOME + File.separator + MULE_LIB_FILENAME);
    }

    public static File getMuleModuleDir() {
        return new File(MULE_HOME + File.separator + MULE_MODULE_FILENAME);
    }

    public static File getMuleLocalJarFile() {
        return new File(JarUtils.getMuleLibDir(), MULE_LOCAL_JAR_FILENAME);
    }
}

