/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mule.RequestContext;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.IOUtils;
import org.mule.util.StringMessageUtils;

public class ObjectToString
extends AbstractTransformer
implements DiscoverableTransformer {
    protected static final int DEFAULT_BUFFER_SIZE = 80;
    private int priorityWeighting = 2;

    public ObjectToString() {
        this.registerSourceType(Object.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(OutputHandler.class);
        this.setReturnClass(String.class);
    }

    /*
     * Loose catch block
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        String output;
        block16: {
            block15: {
                output = "";
                if (!(src instanceof InputStream)) break block15;
                InputStream is = (InputStream)src;
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)is, (OutputStream)byteOut);
                output = new String(byteOut.toByteArray(), encoding);
                Object var7_10 = null;
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.warn((Object)"Could not close stream", (Throwable)e);
                }
                break block16;
                {
                    catch (IOException e) {
                        throw new TransformerException(CoreMessages.errorReadingStream(), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        this.logger.warn((Object)"Could not close stream", (Throwable)e);
                    }
                    throw throwable;
                }
            }
            if (src instanceof OutputHandler) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                try {
                    ((OutputHandler)src).write(RequestContext.getEvent(), bytes);
                    output = new String(bytes.toByteArray(), encoding);
                }
                catch (IOException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            } else if (src instanceof byte[]) {
                try {
                    output = new String((byte[])src, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            } else {
                output = StringMessageUtils.toString(src);
            }
        }
        return output;
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

