/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;

public class MulticastingRouter
extends FilteringOutboundRouter {
    public MuleMessage route(MuleMessage message, MuleSession session) throws RoutingException {
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(this.endpoints.size());
            }
        }
        ArrayList<MuleMessage> results = new ArrayList<MuleMessage>(this.endpoints.size());
        try {
            for (int i = 0; i < this.endpoints.size(); ++i) {
                OutboundEndpoint endpoint = (OutboundEndpoint)this.endpoints.get(i);
                if (endpoint.getFilter() != null && (endpoint.getFilter() == null || !endpoint.getFilter().accept(message))) continue;
                if (((DefaultMuleMessage)message).isConsumable()) {
                    throw new MessagingException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getClass().getName()), message);
                }
                DefaultMuleMessage clonedMessage = new DefaultMuleMessage(message.getPayload(), message);
                if (endpoint.isSynchronous()) {
                    results.add(this.send(session, clonedMessage, endpoint));
                    continue;
                }
                this.dispatch(session, clonedMessage, endpoint);
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(message, (ImmutableEndpoint)this.endpoints.get(0), (Throwable)e);
        }
        return this.resultsHandler.aggregateResults(results, message);
    }
}

