/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.BlockingServerEvent;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.context.notification.Configuration;
import org.mule.context.notification.ListenerSubscriptionPair;
import org.mule.context.notification.Policy;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerNotificationManager
implements Work,
Disposable,
ServerNotificationHandler {
    public static final String NULL_SUBSCRIPTION = "NULL";
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean dynamic = false;
    private Configuration configuration = new Configuration();
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private BlockingDeque eventQueue = new LinkedBlockingDeque();

    @Override
    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    public void setNotificationDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void start(WorkManager workManager, WorkListener workListener) throws LifecycleException {
        try {
            workManager.scheduleWork(this, Long.MAX_VALUE, null, workListener);
        }
        catch (WorkException e) {
            throw new LifecycleException(e, (Object)this);
        }
    }

    public void addInterfaceToType(Class<? extends ServerNotificationListener> iface, Class<? extends ServerNotification> event) {
        this.configuration.addInterfaceToType(iface, event);
    }

    public void setInterfaceToTypes(Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> interfaceToEvents) throws ClassNotFoundException {
        this.configuration.addAllInterfaceToTypes(interfaceToEvents);
    }

    public void addListenerSubscriptionPair(ListenerSubscriptionPair pair) {
        this.configuration.addListenerSubscriptionPair(pair);
    }

    public void addListener(ServerNotificationListener listener) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair(listener));
    }

    public void addListenerSubscription(ServerNotificationListener listener, String subscription) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair(listener, subscription));
    }

    public void setAllListenerSubscriptionPairs(Collection pairs) {
        this.configuration.addAllListenerSubscriptionPairs(pairs);
    }

    public void removeListener(ServerNotificationListener listener) {
        this.configuration.removeListener(listener);
    }

    public void removeAllListeners(Collection<ServerNotificationListener> listeners) {
        this.configuration.removeAllListeners(listeners);
    }

    public void disableInterface(Class<? extends ServerNotificationListener> iface) throws ClassNotFoundException {
        this.configuration.disableInterface(iface);
    }

    public void setDisabledInterfaces(Collection<Class<? extends ServerNotificationListener>> interfaces) throws ClassNotFoundException {
        this.configuration.disabledAllInterfaces(interfaces);
    }

    public void disableType(Class<? extends ServerNotification> type) throws ClassNotFoundException {
        this.configuration.disableType(type);
    }

    public void setDisabledTypes(Collection<Class<? extends ServerNotificationListener>> types) throws ClassNotFoundException {
        this.configuration.disableAllTypes(types);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fireNotification(ServerNotification notification) {
        if (!this.disposed.get()) {
            if (notification instanceof BlockingServerEvent) {
                this.notifyListeners(notification);
                return;
            } else {
                try {
                    this.eventQueue.put((Object)notification);
                    return;
                }
                catch (InterruptedException e) {
                    if (this.disposed.get()) return;
                    this.logger.error((Object)("Failed to queue notification: " + notification), (Throwable)e);
                }
            }
            return;
        } else {
            this.logger.warn((Object)("Notification not enqueued after ServerNotificationManager disposal: " + notification));
        }
    }

    @Override
    public boolean isNotificationEnabled(Class<? extends ServerNotification> type) {
        Policy policy;
        boolean enabled = false;
        if (this.configuration != null && (policy = this.configuration.getPolicy()) != null) {
            enabled = policy.isNotificationEnabled(type);
        }
        return enabled;
    }

    @Override
    public void dispose() {
        this.disposed.set(true);
        this.configuration = null;
    }

    protected void notifyListeners(ServerNotification notification) {
        if (!this.disposed.get()) {
            this.configuration.getPolicy().dispatch(notification);
        } else {
            this.logger.warn((Object)("Notification not delivered after ServerNotificationManager disposal: " + notification));
        }
    }

    public void release() {
        this.dispose();
    }

    public void run() {
        while (!this.disposed.get()) {
            try {
                ServerNotification notification = (ServerNotification)this.eventQueue.take();
                this.notifyListeners(notification);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static Class toClass(Object value) throws ClassNotFoundException {
        Class clazz;
        if (value instanceof String) {
            clazz = ClassUtils.loadClass(value.toString(), value.getClass());
        } else if (value instanceof Class) {
            clazz = (Class)value;
        } else {
            throw new IllegalArgumentException("Notification types and listeners must be a Class with fully qualified class name. Value is: " + value);
        }
        return clazz;
    }

    Policy getPolicy() {
        return this.configuration.getPolicy();
    }

    public Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> getInterfaceToTypes() {
        return Collections.unmodifiableMap(this.configuration.getInterfaceToTypes());
    }

    public Set<ListenerSubscriptionPair> getListeners() {
        return Collections.unmodifiableSet(this.configuration.getListeners());
    }
}

