/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.NullSessionHandler;
import org.mule.agent.AbstractNotificationLoggerAgent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.NullPayload;

public class EndpointNotificationLoggerAgent
extends AbstractNotificationLoggerAgent {
    private OutboundEndpoint endpoint = null;
    private MuleSession session;
    private List ignoredNotifications = new ArrayList();

    public EndpointNotificationLoggerAgent() {
        super("Endpoint Logger Agent");
        this.ignoredNotifications.add(new Integer(106));
        this.ignoredNotifications.add(new Integer(107));
        this.ignoredNotifications.add(new Integer(108));
        this.ignoredNotifications.add(new Integer(208));
        this.ignoredNotifications.add(new Integer(209));
        this.ignoredNotifications.add(new Integer(210));
    }

    protected void doInitialise() throws InitialisationException {
        try {
            if (this.endpoint == null) {
                throw new InitialisationException(CoreMessages.propertiesNotSet("endpoint"), (Initialisable)this);
            }
            this.session = new DefaultMuleSession(new DefaultMuleMessage((Object)NullPayload.getInstance(), (Map)null), new NullSessionHandler(), this.muleContext);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void logEvent(ServerNotification e) {
        if (this.muleContext.isDisposing() || this.muleContext.isDisposed()) {
            this.logger.warn((Object)("MuleContext is disposing/disposed, no notification will be processed: " + e));
            return;
        }
        if (this.endpoint != null && !this.ignoredNotifications.contains(new Integer(e.getAction()))) {
            if ((e.getAction() == 702 || e.getAction() == 703) && ((Connector)e.getSource()).equals(this.endpoint.getConnector())) {
                return;
            }
            DefaultMuleMessage msg = new DefaultMuleMessage((Object)e, (Map)null);
            try {
                if (this.endpoint.getFilter() != null && !this.endpoint.getFilter().accept(msg)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Message not accepted with filter: " + this.endpoint.getFilter()));
                    }
                    return;
                }
                DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)msg, (ImmutableEndpoint)this.endpoint, this.session, false);
                this.endpoint.dispatch(event);
            }
            catch (Exception e1) {
                this.logger.error((Object)("Failed to dispatch event: " + e.toString() + " over endpoint: " + this.endpoint + ". Error is: " + e1.getMessage()), (Throwable)e1);
            }
        }
    }

    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append(": ");
        if (this.endpoint != null) {
            buf.append("Forwarding notifications to: " + this.endpoint.getEndpointURI().getAddress());
        }
        return buf.toString();
    }

    public OutboundEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(OutboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }
}

