/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.service;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.registry.ServiceException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.BeanUtils;
import org.mule.util.ObjectNameHelper;

public class TransportFactory {
    protected static final Log logger = LogFactory.getLog(TransportFactory.class);

    public static Connector createConnector(EndpointURI url, MuleContext muleContext) throws TransportFactoryException {
        try {
            String scheme = url.getSchemeMetaInfo();
            TransportServiceDescriptor sd = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", scheme, null);
            if (sd == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
            }
            Connector connector = sd.createConnector();
            if (connector != null) {
                if (connector instanceof AbstractConnector) {
                    ((AbstractConnector)connector).initialiseFromUrl(url);
                }
            } else {
                throw new TransportFactoryException(CoreMessages.objectNotSetInService("Connector", scheme));
            }
            connector.setName(ObjectNameHelper.getConnectorName(connector));
            return connector;
        }
        catch (Exception e) {
            throw new TransportFactoryException(CoreMessages.failedToCreateObjectWith("Endpoint", url), (Throwable)e);
        }
    }

    public static Connector getOrCreateConnectorByProtocol(ImmutableEndpoint endpoint, MuleContext muleContext) throws TransportFactoryException {
        return TransportFactory.getOrCreateConnectorByProtocol(endpoint.getEndpointURI(), muleContext);
    }

    public static Connector getOrCreateConnectorByProtocol(EndpointURI uri, MuleContext muleContext) throws TransportFactoryException {
        Connector connector;
        String connectorName = uri.getConnectorName();
        if (null != connectorName && (connector = RegistryContext.getRegistry().lookupConnector(connectorName)) != null) {
            return connector;
        }
        connector = TransportFactory.getConnectorByProtocol(uri.getFullScheme());
        if (connector == null) {
            connector = TransportFactory.createConnector(uri, muleContext);
            try {
                BeanUtils.populate(connector, uri.getParams());
                connector.setMuleContext(muleContext);
                muleContext.getRegistry().registerConnector(connector);
            }
            catch (Exception e) {
                throw new TransportFactoryException(e);
            }
        }
        return connector;
    }

    public static Connector getConnectorByProtocol(String protocol) {
        Connector resultConnector = null;
        Collection connectors = RegistryContext.getRegistry().lookupObjects(Connector.class);
        for (Connector connector : connectors) {
            if (!connector.supportsProtocol(protocol)) continue;
            if (resultConnector == null) {
                resultConnector = connector;
                continue;
            }
            throw new IllegalStateException(CoreMessages.moreThanOneConnectorWithProtocol(protocol).getMessage());
        }
        return resultConnector;
    }
}

