/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.mule.MuleServer;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.transaction.AbstractTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionRollbackException;
import org.mule.transaction.TransactionStatusException;

public class XaTransaction
extends AbstractTransaction {
    private Transaction transaction = null;
    private Map resources = new HashMap();
    private TransactionManager txManager;

    public XaTransaction(TransactionManager txManager) {
        this.txManager = txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBegin() throws TransactionException {
        if (this.txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            this.txManager.begin();
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                this.transaction = this.txManager.getTransaction();
            }
        }
        catch (Exception e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    protected synchronized void doCommit() throws TransactionException {
        try {
            this.delistResources();
            this.txManager.commit();
        }
        catch (RollbackException e) {
            throw new TransactionRollbackException(CoreMessages.transactionMarkedForRollback(), (Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionRollbackException(CoreMessages.transactionMarkedForRollback(), (Throwable)e);
        }
        catch (Exception e) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCommitFailed(), (Throwable)e);
        }
        finally {
            this.transaction = null;
            this.closeResources();
        }
    }

    protected void doRollback() throws TransactionRollbackException {
        try {
            this.txManager.rollback();
        }
        catch (SystemException e) {
            throw new TransactionRollbackException(e);
        }
        catch (Exception e) {
            throw new TransactionRollbackException(e);
        }
        finally {
            this.transaction = null;
            this.closeResources();
        }
    }

    public synchronized int getStatus() throws TransactionStatusException {
        if (this.transaction == null) {
            return 6;
        }
        try {
            return this.transaction.getStatus();
        }
        catch (SystemException e) {
            throw new TransactionStatusException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() {
        if (this.transaction == null) {
            throw new IllegalStateException("Current thread is not associated with a transaction.");
        }
        try {
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                this.transaction.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            throw (IllegalStateException)new IllegalStateException("Failed to set transaction to rollback only: " + e.getMessage()).initCause(e);
        }
    }

    public synchronized Object getResource(Object key) {
        return this.resources.get(key);
    }

    public synchronized boolean hasResource(Object key) {
        return this.resources.containsKey(key);
    }

    public synchronized void bindResource(Object key, Object resource) throws TransactionException {
        if (this.resources.containsKey(key)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionResourceAlreadyListedForKey(key));
        }
        this.resources.put(key, resource);
        if (key == null) {
            this.logger.error((Object)("Key for bound resource " + resource + " is null"));
        }
        if (resource instanceof MuleXaObject) {
            MuleXaObject xaObject = (MuleXaObject)resource;
            xaObject.enlist();
        } else if (resource instanceof XAResource) {
            this.enlistResource((XAResource)resource);
        } else {
            this.logger.error((Object)("Bound resource " + resource + " is neither a MuleXaObject nor XAResource"));
        }
    }

    public boolean enlistResource(XAResource resource) throws TransactionException {
        TransactionManager txManager = MuleServer.getMuleContext().getTransactionManager();
        try {
            Transaction jtaTransaction = txManager.getTransaction();
            if (jtaTransaction == null) {
                throw new TransactionException(MessageFactory.createStaticMessage("XATransaction is null"));
            }
            return jtaTransaction.enlistResource(resource);
        }
        catch (RollbackException e) {
            throw new TransactionException(e);
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
    }

    public boolean delistResource(XAResource resource, int tmflag) throws TransactionException {
        TransactionManager txManager = MuleServer.getMuleContext().getTransactionManager();
        try {
            Transaction jtaTransaction = txManager.getTransaction();
            if (jtaTransaction == null) {
                throw new TransactionException(CoreMessages.noJtaTransactionAvailable(Thread.currentThread()));
            }
            return jtaTransaction.delistResource(resource, tmflag);
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
    }

    public String toString() {
        return this.transaction == null ? " <n/a>" : this.transaction.toString();
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public boolean isXA() {
        return true;
    }

    public void resume() throws TransactionException {
        TransactionManager txManager = MuleServer.getMuleContext().getTransactionManager();
        if (txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            txManager.resume(this.transaction);
        }
        catch (InvalidTransactionException e) {
            throw new TransactionException(e);
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
    }

    public Transaction suspend() throws TransactionException {
        TransactionManager txManager = MuleServer.getMuleContext().getTransactionManager();
        if (txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            this.transaction = txManager.suspend();
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
        return this.transaction;
    }

    protected void delistResources() {
        for (Map.Entry entry : this.resources.entrySet()) {
            Object xaObject = entry.getValue();
            if (!(xaObject instanceof MuleXaObject)) continue;
            try {
                ((MuleXaObject)xaObject).delist();
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to delist resource " + xaObject), (Throwable)e);
            }
        }
    }

    protected void closeResources() {
        Iterator i = this.resources.entrySet().iterator();
        while (i.hasNext()) {
            MuleXaObject xaObject;
            Map.Entry entry = i.next();
            Object value = entry.getValue();
            if (!(value instanceof MuleXaObject) || (xaObject = (MuleXaObject)value).isReuseObject()) continue;
            try {
                xaObject.close();
                i.remove();
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to close resource " + xaObject), (Throwable)e);
            }
        }
    }

    public static interface MuleXaObject {
        public static final String SET_REUSE_OBJECT_METHOD_NAME = "setReuseObject";
        public static final String IS_REUSE_OBJECT_METHOD_NAME = "isReuseObject";
        public static final String DELIST_METHOD_NAME = "delist";
        public static final String ENLIST_METHOD_NAME = "enlist";
        public static final String GET_TARGET_OBJECT_METHOD_NAME = "getTargetObject";
        public static final String CLOSE_METHOD_NAME = "close";

        public void close() throws Exception;

        public void setReuseObject(boolean var1);

        public boolean isReuseObject();

        public boolean enlist() throws TransactionException;

        public boolean delist() throws Exception;

        public Object getTargetObject();
    }
}

