/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.transport.NullPayload;

public class ChainingRouter
extends FilteringOutboundRouter {
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new InitialisationException(CoreMessages.objectIsNull("endpoints"), (Initialisable)this);
        }
    }

    public MuleMessage route(MuleMessage message, MuleSession session) throws RoutingException {
        MuleMessage resultToReturn = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        int endpointsCount = this.endpoints.size();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("About to chain " + endpointsCount + " endpoints."));
        }
        OutboundEndpoint endpoint = null;
        try {
            MuleMessage intermediaryResult = message;
            for (int i = 0; i < endpointsCount; ++i) {
                boolean lastEndpointInChain;
                endpoint = this.getEndpoint(i, intermediaryResult);
                boolean bl = lastEndpointInChain = i == endpointsCount - 1;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending Chained message '" + i + "': " + (intermediaryResult == null ? "null" : intermediaryResult.toString())));
                }
                intermediaryResult.setProperty("MULE_REMOTE_SYNC", true);
                if (!lastEndpointInChain) {
                    MuleMessage localResult = this.send(session, intermediaryResult, endpoint);
                    if (localResult != null && localResult.getPayload() != NullPayload.getInstance() && intermediaryResult != null) {
                        this.processIntermediaryResult(localResult, intermediaryResult);
                    }
                    intermediaryResult = localResult;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Received Chain result '" + i + "': " + (intermediaryResult != null ? intermediaryResult.toString() : "null")));
                    }
                    if (intermediaryResult != null && intermediaryResult.getPayload() != NullPayload.getInstance()) continue;
                    resultToReturn = intermediaryResult;
                    this.logger.warn((Object)("Chaining router cannot process any further endpoints. There was no result returned from endpoint invocation: " + endpoint));
                    break;
                }
                if (endpoint.isSynchronous()) {
                    resultToReturn = this.send(session, intermediaryResult, endpoint);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Received final Chain result '" + i + "': " + (resultToReturn == null ? "null" : resultToReturn.toString())));
                    continue;
                }
                resultToReturn = null;
                this.dispatch(session, intermediaryResult, endpoint);
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(message, endpoint, (Throwable)e);
        }
        return resultToReturn;
    }

    protected void processIntermediaryResult(MuleMessage localResult, MuleMessage intermediaryResult) {
        localResult.setCorrelationId(intermediaryResult.getCorrelationId());
        localResult.setCorrelationSequence(intermediaryResult.getCorrelationSequence());
        localResult.setCorrelationGroupSize(intermediaryResult.getCorrelationGroupSize());
        localResult.setReplyTo(intermediaryResult.getReplyTo());
    }
}

