/*
 * Decompiled with CFR 0.152.
 */
package org.mule.object;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;

public abstract class AbstractObjectFactory
implements ObjectFactory {
    public static final String ATTRIBUTE_OBJECT_CLASS_NAME = "objectClassName";
    public static final String ATTRIBUTE_OBJECT_CLASS = "objectClass";
    protected String objectClassName;
    protected Class objectClass = null;
    protected Map properties = null;
    protected List initialisationCallbacks = new ArrayList();
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public AbstractObjectFactory() {
    }

    public AbstractObjectFactory(String objectClassName) {
        this(objectClassName, null);
    }

    public AbstractObjectFactory(String objectClassName, Map properties) {
        this.objectClassName = objectClassName;
        this.properties = properties;
    }

    public AbstractObjectFactory(Class objectClass) {
        this(objectClass, null);
    }

    public AbstractObjectFactory(Class objectClass, Map properties) {
        this.objectClass = objectClass;
        this.properties = properties;
    }

    public void initialise() throws InitialisationException {
        if (this.objectClass == null && this.objectClassName == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
        }
        if (this.objectClass == null && this.objectClassName != null) {
            try {
                this.objectClass = ClassUtils.getClass((String)this.objectClassName);
            }
            catch (ClassNotFoundException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public void dispose() {
        this.objectClass = null;
        this.objectClassName = null;
    }

    public Object getInstance() throws Exception {
        if (this.objectClass == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
        }
        Object object = ClassUtils.instanciateClass(this.objectClass, new Object[0]);
        if (this.properties != null) {
            BeanUtils.populateWithoutFail(object, this.properties, true);
        }
        this.fireInitialisationCallbacks(object);
        return object;
    }

    protected void fireInitialisationCallbacks(Object component) throws InitialisationException {
        for (InitialisationCallback callback : this.initialisationCallbacks) {
            callback.initialise(component);
        }
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    protected String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
    }

    protected Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void addObjectInitialisationCallback(InitialisationCallback callback) {
        this.initialisationCallbacks.add(callback);
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isExternallyManagedLifecycle() {
        return false;
    }
}

