/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.AbstractEndpointBuilder;

public class EndpointInfoExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "endpoint";
    protected final transient Log logger = LogFactory.getLog(EndpointInfoExpressionEvaluator.class);

    public Object evaluate(String expression, MuleMessage message) {
        int i = expression.indexOf(".");
        if (i <= 0) {
            throw new IllegalArgumentException(CoreMessages.expressionMalformed(expression, this.getName()).getMessage());
        }
        String endpointName = expression.substring(0, i);
        String property = expression.substring(i + 1);
        AbstractEndpointBuilder eb = (AbstractEndpointBuilder)MuleServer.getMuleContext().getRegistry().lookupEndpointBuilder(endpointName);
        if (eb != null) {
            if (property.equalsIgnoreCase("address")) {
                return eb.getEndpointBuilder().getEndpoint().getAddress();
            }
            throw new IllegalArgumentException(CoreMessages.expressionInvalidForProperty(property, expression).getMessage());
        }
        this.logger.warn((Object)("There is no endpoint registered with name: " + endpointName));
        return null;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }
}

