/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.ObjectProcessor;
import org.mule.api.registry.Registry;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.util.StreamCloser;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;
import org.mule.util.ExceptionUtils;
import org.mule.util.PropertiesUtils;

public class SimpleRegistryBootstrap
implements Initialisable,
MuleContextAware {
    public static final String SERVICE_PATH = "META-INF/services/org/mule/config/";
    public static final String REGISTRY_PROPERTIES = "registry-bootstrap.properties";
    public String TRANSFORMER_PREFIX = "transformer.";
    public String OBJECT_PREFIX = "object.";
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleContext context;

    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public void initialise() throws InitialisationException {
        Enumeration e = ClassUtils.getResources("META-INF/services/org/mule/config/registry-bootstrap.properties", this.getClass());
        while (e.hasMoreElements()) {
            try {
                URL url = (URL)e.nextElement();
                Properties p = new Properties();
                p.load(url.openStream());
                this.process(p);
            }
            catch (Exception e1) {
                throw new InitialisationException((Throwable)e1, (Initialisable)this);
            }
        }
    }

    protected void process(Properties props) throws Exception {
        this.registerTransformers(props, this.context.getRegistry());
        this.registerUnnamedObjects(props, this.context.getRegistry());
        this.registerObjects(props, this.context.getRegistry());
    }

    private void registerTransformers(Properties props, MuleRegistry registry) throws Exception {
        int i = 1;
        String transString = props.getProperty(this.TRANSFORMER_PREFIX + i);
        String name = null;
        String returnClassString = null;
        boolean optional = false;
        while (transString != null) {
            Class returnClass = null;
            int x = transString.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(transString.substring(x + 1), ',');
                name = p.getProperty("name", null);
                returnClassString = p.getProperty("returnClass", null);
                optional = p.containsKey("optional");
            }
            String transClass = x == -1 ? transString : transString.substring(0, x);
            try {
                Transformer trans;
                if (returnClassString != null) {
                    returnClass = returnClassString.equals("byte[]") ? byte[].class : ClassUtils.loadClass(returnClassString, this.getClass());
                }
                if (!((trans = (Transformer)ClassUtils.instanciateClass(transClass, new Object[0])) instanceof DiscoverableTransformer)) {
                    throw new TransformerException(CoreMessages.transformerNotImplementDiscoverable(trans));
                }
                if (returnClass != null) {
                    trans.setReturnClass(returnClass);
                }
                if (name != null) {
                    trans.setName(name);
                } else {
                    name = trans.getName();
                    trans.setName("_" + name);
                }
                registry.registerTransformer(trans);
            }
            catch (InvocationTargetException itex) {
                Throwable cause = ExceptionUtils.getCause((Throwable)itex);
                if (cause instanceof NoClassDefFoundError && optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring optional transformer: " + transClass));
                    }
                }
                throw new Exception(cause);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring optional transformer: " + transClass));
                    }
                }
                throw ncdfe;
            }
            catch (ClassNotFoundException cnfe) {
                if (optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring optional transformer: " + transClass));
                    }
                }
                throw cnfe;
            }
            props.remove(this.TRANSFORMER_PREFIX + i++);
            name = null;
            returnClass = null;
            transString = props.getProperty(this.TRANSFORMER_PREFIX + i);
        }
    }

    private void registerObjects(Properties props, Registry registry) throws Exception {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String className = entry.getValue().toString();
            boolean optional = false;
            try {
                int x = className.indexOf(",");
                if (x > -1) {
                    Properties p = PropertiesUtils.getPropertiesFromString(className.substring(x + 1), ',');
                    optional = p.containsKey("optional");
                }
                Object object = ClassUtils.instanciateClass(className, new Object[0]);
                String key = entry.getKey().toString();
                Class<Object> meta = Object.class;
                if (object instanceof ObjectProcessor) {
                    meta = ObjectProcessor.class;
                }
                registry.registerObject(key, object, meta);
            }
            catch (InvocationTargetException itex) {
                Throwable cause = ExceptionUtils.getCause((Throwable)itex);
                if (cause instanceof NoClassDefFoundError && optional) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Ignoring optional object: " + className));
                    continue;
                }
                throw new Exception(cause);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (optional) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Ignoring optional object: " + className));
                    continue;
                }
                throw ncdfe;
            }
            catch (ClassNotFoundException cnfe) {
                if (optional) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Ignoring optional object: " + className));
                    continue;
                }
                throw cnfe;
            }
        }
        props.clear();
    }

    private void registerUnnamedObjects(Properties props, Registry registry) throws Exception {
        int i = 1;
        String objectString = props.getProperty(this.OBJECT_PREFIX + i);
        while (objectString != null) {
            boolean optional = false;
            try {
                int x = objectString.indexOf(",");
                if (x > -1) {
                    Properties p = PropertiesUtils.getPropertiesFromString(objectString.substring(x + 1), ',');
                    optional = p.containsKey("optional");
                }
                Object o = ClassUtils.instanciateClass(objectString, new Object[0]);
                Class<Object> meta = Object.class;
                if (o instanceof ObjectProcessor) {
                    meta = ObjectProcessor.class;
                } else if (o instanceof StreamCloser) {
                    meta = StreamCloser.class;
                }
                registry.registerObject(this.OBJECT_PREFIX + i + "#" + o.hashCode(), o, meta);
            }
            catch (InvocationTargetException itex) {
                Throwable cause = ExceptionUtils.getCause((Throwable)itex);
                if (cause instanceof NoClassDefFoundError && optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring optional unnamed object: " + objectString));
                    }
                }
                throw new Exception(cause);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring optional unnamed object: " + objectString));
                    }
                }
                throw ncdfe;
            }
            catch (ClassNotFoundException cnfe) {
                if (optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring optional unnamed object: " + objectString));
                    }
                }
                throw cnfe;
            }
            props.remove(this.OBJECT_PREFIX + i++);
            objectString = props.getProperty(this.OBJECT_PREFIX + i);
        }
    }
}

