/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ExceptionReader;
import org.mule.config.DefaultExceptionReader;
import org.mule.config.MuleExceptionReader;
import org.mule.config.NamingExceptionReader;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;
import org.mule.util.MapUtils;
import org.mule.util.StringUtils;

public final class ExceptionHelper {
    public static final String ERROR_CODE_PROPERTY = "error.code.property";
    public static final String APPLY_TO_PROPERTY = "apply.to";
    protected static final Log logger = LogFactory.getLog(ExceptionHelper.class);
    private static String J2SE_VERSION = "";
    private static final String J2EE_VERSION = "1.3ee";
    private static Properties errorDocs = new Properties();
    private static Properties errorCodes = new Properties();
    private static Map reverseErrorCodes = null;
    private static Map errorMappings = new HashMap();
    private static int exceptionThreshold = 0;
    private static boolean verbose = true;
    private static boolean initialised = false;
    private static List exceptionReaders = new ArrayList();
    private static ExceptionReader defaultExceptionReader = new DefaultExceptionReader();

    private ExceptionHelper() {
    }

    private static void initialise() {
        try {
            if (initialised) {
                return;
            }
            ExceptionHelper.registerExceptionReader(new MuleExceptionReader());
            ExceptionHelper.registerExceptionReader(new NamingExceptionReader());
            J2SE_VERSION = System.getProperty("java.specification.version");
            String name = "META-INF/services/org/mule/config/mule-exception-codes.properties";
            InputStream in = ExceptionHelper.class.getClassLoader().getResourceAsStream(name);
            if (in == null) {
                throw new IllegalArgumentException("Failed to load resource: " + name);
            }
            errorCodes.load(in);
            in.close();
            reverseErrorCodes = MapUtils.invertMap((Map)errorCodes);
            name = "META-INF/services/org/mule/config/mule-exception-config.properties";
            in = ExceptionHelper.class.getClassLoader().getResourceAsStream(name);
            if (in == null) {
                throw new IllegalArgumentException("Failed to load resource: " + name);
            }
            errorDocs.load(in);
            in.close();
            initialised = true;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToLoad("Exception resources"), (Throwable)e);
        }
    }

    public static int getErrorCode(Class exception) {
        String code = errorCodes.getProperty(exception.getName(), "-1");
        return Integer.parseInt(code);
    }

    public static Class getErrorClass(int code) {
        String key = String.valueOf(code);
        Object clazz = reverseErrorCodes.get(key);
        if (clazz == null) {
            return null;
        }
        if (clazz instanceof Class) {
            return (Class)clazz;
        }
        try {
            clazz = ClassUtils.loadClass(clazz.toString(), ExceptionHelper.class);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        reverseErrorCodes.put(key, clazz);
        return (Class)clazz;
    }

    private static Properties getErrorMappings(String protocol) {
        Object m = errorMappings.get(protocol);
        if (m != null) {
            if (m instanceof Properties) {
                return (Properties)m;
            }
            return null;
        }
        String name = "META-INF/services/org/mule/config/" + protocol + "-exception-mappings.properties";
        InputStream in = ExceptionHelper.class.getClassLoader().getResourceAsStream(name);
        if (in == null) {
            errorMappings.put(protocol, "not found");
            logger.warn((Object)("Failed to load error mappings from: " + name + " This may be because there are no error code mappings for protocol: " + protocol));
            return null;
        }
        Properties p = new Properties();
        try {
            p.load(in);
            in.close();
        }
        catch (IOException iox) {
            throw new IllegalArgumentException("Failed to load resource: " + name);
        }
        errorMappings.put(protocol, p);
        String applyTo = p.getProperty(APPLY_TO_PROPERTY, null);
        if (applyTo != null) {
            String[] protocols = StringUtils.splitAndTrim(applyTo, ",");
            for (int i = 0; i < protocols.length; ++i) {
                errorMappings.put(protocols[i], p);
            }
        }
        return p;
    }

    public static String getErrorCodePropertyName(String protocol) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase());
        if (mappings == null) {
            return null;
        }
        return mappings.getProperty(ERROR_CODE_PROPERTY);
    }

    public static String getErrorMapping(String protocol, Class exception) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase());
        if (mappings == null) {
            logger.info((Object)("No mappings found for protocol: " + protocol));
            return String.valueOf(ExceptionHelper.getErrorCode(exception));
        }
        Class clazz = exception;
        String code = null;
        while (!clazz.equals(Object.class)) {
            code = mappings.getProperty(clazz.getName());
            if (code == null) {
                clazz = clazz.getSuperclass();
                continue;
            }
            return code;
        }
        code = String.valueOf(ExceptionHelper.getErrorCode(exception));
        return mappings.getProperty(code, code);
    }

    public static String getJavaDocUrl(Class exception) {
        return ExceptionHelper.getDocUrl("javadoc.", exception.getName());
    }

    public static String getDocUrl(Class exception) {
        return ExceptionHelper.getDocUrl("doc.", exception.getName());
    }

    private static String getDocUrl(String prefix, String packageName) {
        String url;
        String key = prefix;
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            key = key + J2SE_VERSION;
        }
        if ((url = ExceptionHelper.getUrl(key, packageName)) == null && (packageName.startsWith("java.") || packageName.startsWith("javax."))) {
            key = prefix + J2EE_VERSION;
            url = ExceptionHelper.getUrl(key, packageName);
        }
        if (url != null) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            String s = packageName.replaceAll("[.]", "/");
            s = s + ".html";
            url = url + s;
        }
        return url;
    }

    private static String getUrl(String key, String packageName) {
        String url = null;
        if (!key.endsWith(".")) {
            key = key + ".";
        }
        while (packageName.length() > 0 && (url = errorDocs.getProperty(key + packageName, null)) == null) {
            int i = packageName.lastIndexOf(".");
            if (i == -1) {
                packageName = "";
                continue;
            }
            packageName = packageName.substring(0, i);
        }
        return url;
    }

    public static Throwable getRootException(Throwable t) {
        Throwable cause = t;
        Throwable root = null;
        while (cause != null) {
            root = cause;
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return root;
    }

    public static Throwable getRootParentException(Throwable t) {
        Throwable cause = t;
        Throwable parent = t;
        while (cause != null) {
            if (cause.getCause() == null) {
                return parent;
            }
            parent = cause;
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return t;
    }

    public static MuleException getRootMuleException(Throwable t) {
        Throwable cause = t;
        MuleException exception = null;
        while (cause != null) {
            if (cause instanceof MuleException) {
                exception = (MuleException)cause;
            }
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return exception;
    }

    public static List getExceptionsAsList(Throwable t) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Throwable cause = t;
        while (cause != null) {
            exceptions.add(0, cause);
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return exceptions;
    }

    public static Map getExceptionInfo(Throwable t) {
        HashMap info = new HashMap();
        Throwable cause = t;
        while (cause != null) {
            info.putAll(ExceptionHelper.getExceptionReader(cause).getInfo(cause));
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return info;
    }

    public static String getExceptionStack(Throwable t) {
        StringBuffer buf = new StringBuffer();
        List exceptions = ExceptionHelper.getExceptionsAsList(t);
        int i = 1;
        Iterator iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            if (i > exceptionThreshold && exceptionThreshold > 0) {
                buf.append("(").append(exceptions.size() - i + 1).append(" more...)");
                break;
            }
            Throwable throwable = (Throwable)iterator.next();
            ExceptionReader er = ExceptionHelper.getExceptionReader(throwable);
            buf.append(i).append(". ").append(er.getMessage(throwable)).append(" (");
            buf.append(throwable.getClass().getName()).append(")\n");
            if (verbose && throwable.getStackTrace().length > 0) {
                StackTraceElement e = throwable.getStackTrace()[0];
                buf.append("  ").append(e.getClassName()).append(":").append(e.getLineNumber()).append(" (").append(ExceptionHelper.getJavaDocUrl(throwable.getClass())).append(")\n");
            }
            ++i;
        }
        return buf.toString();
    }

    public static void registerExceptionReader(ExceptionReader reader) {
        exceptionReaders.add(reader);
    }

    public static ExceptionReader getExceptionReader(Throwable t) {
        for (ExceptionReader exceptionReader : exceptionReaders) {
            if (!exceptionReader.getExceptionType().isInstance(t)) continue;
            return exceptionReader;
        }
        return defaultExceptionReader;
    }

    public static String writeException(Throwable t) {
        ExceptionReader er = ExceptionHelper.getExceptionReader(t);
        StringBuffer msg = new StringBuffer();
        msg.append(er.getMessage(t)).append(". Type: ").append(t.getClass());
        return msg.toString();
    }

    static {
        ExceptionHelper.initialise();
    }
}

