/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapCombiner
implements Map {
    public static final String LIST = "list";
    public static final int UNLIMITED_DEPTH = -1;
    private Log logger = LogFactory.getLog(this.getClass());
    private int maxDepth = -1;
    private List list;
    private Map cachedMerge = new HashMap();
    private boolean isMerged = false;

    private synchronized Map getCachedMerge() {
        if (!this.isMerged) {
            Iterator maps = this.list.iterator();
            while (maps.hasNext()) {
                this.mergeMaps(this.maxDepth, this.cachedMerge, (Map)maps.next());
            }
            this.isMerged = true;
        }
        return this.cachedMerge;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    private void mergeMaps(int headroom, Map accumulator, Map extra) {
        for (Object key : extra.keySet()) {
            Object valueExtra = extra.get(key);
            if (accumulator.containsKey(key)) {
                Object valueOriginal = accumulator.get(key);
                if (valueExtra instanceof Map && valueOriginal instanceof Map && headroom != 0) {
                    this.mergeMaps(headroom - 1, (Map)valueOriginal, (Map)valueExtra);
                    continue;
                }
                if (valueExtra instanceof Collection && valueOriginal instanceof Collection && headroom != 0) {
                    ((Collection)valueOriginal).addAll((Collection)valueExtra);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Overwriting " + valueOriginal + " for " + key + " during map merge"));
                }
                accumulator.put(key, valueExtra);
                continue;
            }
            accumulator.put(key, valueExtra);
        }
    }

    public void setList(List list) {
        this.assertNotMerged();
        this.list = list;
    }

    public List getList() {
        this.assertNotMerged();
        return this.list;
    }

    private synchronized void assertNotMerged() {
        if (this.isMerged) {
            throw new IllegalStateException("Maps have already been merged");
        }
    }

    public int hashCode() {
        return ((Object)this.cachedMerge).hashCode();
    }

    public boolean equals(Object o) {
        return ((Object)this.cachedMerge).equals(o);
    }

    public String toString() {
        if (this.isMerged) {
            return "merged: " + this.cachedMerge.toString();
        }
        return "unmerged: " + (null == this.list ? null : this.list.toString());
    }

    public int size() {
        return this.getCachedMerge().size();
    }

    public void clear() {
        this.getCachedMerge().clear();
    }

    public boolean isEmpty() {
        return this.getCachedMerge().isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.getCachedMerge().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.getCachedMerge().containsValue(value);
    }

    public Collection values() {
        return this.getCachedMerge().values();
    }

    public void putAll(Map t) {
        this.getCachedMerge().putAll(t);
    }

    public Set entrySet() {
        return this.getCachedMerge().entrySet();
    }

    public Set keySet() {
        return this.getCachedMerge().keySet();
    }

    public Object get(Object key) {
        return this.getCachedMerge().get(key);
    }

    public Object remove(Object key) {
        return this.getCachedMerge().remove(key);
    }

    public Object put(Object key, Object value) {
        return this.getCachedMerge().put(key, value);
    }
}

