/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.config.ExceptionHelper;
import org.mule.context.notification.ConnectionNotification;

public class ConnectNotifier
implements RetryNotifier {
    protected final transient Log logger = LogFactory.getLog(ConnectNotifier.class);

    public void onSuccess(RetryContext context) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Successfully connected to " + context.getDescription()));
        }
        this.fireConnectNotification(701, context.getDescription());
    }

    public void onFailure(RetryContext context, Throwable e) {
        this.fireConnectNotification(702, context.getDescription());
        if (this.logger.isErrorEnabled()) {
            StringBuffer msg = new StringBuffer(512);
            msg.append("Failed to connect/reconnect: ").append(context.getDescription());
            Throwable t = ExceptionHelper.getRootException(e);
            msg.append(". Root Exception was: ").append(ExceptionHelper.writeException(t));
            this.logger.error((Object)msg.toString());
        }
    }

    protected void fireConnectNotification(int action, String description) {
        MuleServer.getMuleContext().fireNotification(new ConnectionNotification(null, description, action));
    }
}

