/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.api.model.ModelException;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.ReplyToHandler;
import org.mule.component.simple.PassThroughComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ServiceNotification;
import org.mule.management.stats.ServiceStatistics;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.routing.inbound.InboundPassThroughRouter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.routing.response.DefaultResponseRouterCollection;
import org.mule.transport.AbstractConnector;
import org.mule.transport.NullPayload;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractService
implements Service {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ServiceStatistics stats = null;
    protected AtomicBoolean stopped = new AtomicBoolean(true);
    protected WaitableBoolean stopping = new WaitableBoolean(false);
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected Model model;
    protected WaitableBoolean paused = new WaitableBoolean(false);
    protected MuleContext muleContext;
    public static final String INITIAL_STATE_STOPPED = "stopped";
    public static final String INITIAL_STATE_STARTED = "started";
    public static final String INITIAL_STATE_PAUSED = "paused";
    protected ExceptionListener exceptionListener;
    protected String name;
    protected InboundRouterCollection inboundRouter = new DefaultInboundRouterCollection();
    protected OutboundRouterCollection outboundRouter = new DefaultOutboundRouterCollection();
    protected ResponseRouterCollection responseRouter = new DefaultResponseRouterCollection();
    protected String initialState = "started";
    private AtomicBoolean beyondInitialState = new AtomicBoolean(false);
    protected Component component = new PassThroughComponent();

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new InitialisationException(CoreMessages.objectAlreadyInitialised("Service '" + this.name + "'"), (Initialisable)this);
        }
        this.component.setService(this);
        this.component.initialise();
        if (this.inboundRouter == null) {
            this.inboundRouter = new DefaultInboundRouterCollection();
            this.inboundRouter.addRouter(new InboundPassThroughRouter());
        }
        if (this.outboundRouter == null) {
            this.outboundRouter = new DefaultOutboundRouterCollection();
            this.outboundRouter.addRouter(new OutboundPassThroughRouter());
        }
        if (this.responseRouter == null) {
            this.responseRouter = new DefaultResponseRouterCollection();
        }
        if (this.exceptionListener == null) {
            this.exceptionListener = this.getModel().getExceptionListener();
        }
        this.doInitialise();
        this.stats = this.createStatistics();
        this.stats.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.stats);
        this.stats.setOutboundRouterStat(this.outboundRouter.getStatistics());
        this.stats.setInboundRouterStat(this.inboundRouter.getStatistics());
        this.stats.setComponentStat(this.component.getStatistics());
        this.initialised.set(true);
        this.fireServiceNotification(301);
    }

    protected ServiceStatistics createStatistics() {
        return new ServiceStatistics(this.name);
    }

    protected void fireServiceNotification(int action) {
        this.muleContext.fireNotification(new ServiceNotification(this, action));
    }

    public void forceStop() throws MuleException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping Service");
            this.stopping.set(true);
            this.fireServiceNotification(307);
            this.doForceStop();
            this.stopped.set(true);
            this.stopping.set(false);
            this.fireServiceNotification(303);
        }
    }

    public void stop() throws MuleException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping Service");
            this.stopping.set(true);
            this.fireServiceNotification(307);
            this.unregisterListeners();
            if (this.isPaused()) {
                this.resume();
            }
            this.doStop();
            this.component.stop();
            this.stopped.set(true);
            this.fireServiceNotification(303);
            this.logger.info((Object)("Mule Service " + this.name + " has been stopped successfully"));
        }
    }

    public void start() throws MuleException {
        if (!this.initialised.get()) {
            throw new IllegalStateException("Cannot start an unitialised service.");
        }
        if (this.isStarted()) {
            this.logger.info((Object)("Service is already started: " + this.name));
        } else {
            if (this.initialState.equals(INITIAL_STATE_STOPPED)) {
                this.logger.info((Object)INITIAL_STATE_STOPPED);
            }
            if (!this.beyondInitialState.get() && this.initialState.equals(INITIAL_STATE_STOPPED)) {
                this.logger.info((Object)("Service " + this.name + " has not been started (initial state = 'stopped')"));
            } else if (!this.beyondInitialState.get() && this.initialState.equals(INITIAL_STATE_PAUSED)) {
                this.start(true);
                this.logger.info((Object)("Service " + this.name + " has been started and paused (initial state = 'paused')"));
            } else {
                this.start(false);
                this.logger.info((Object)("Service " + this.name + " has been started successfully"));
            }
            this.beyondInitialState.set(true);
        }
    }

    protected void start(boolean startPaused) throws MuleException {
        this.component.start();
        this.registerListeners();
        this.connectListeners();
        if (this.stopped.get()) {
            this.stopped.set(false);
            this.paused.set(false);
            this.doStart();
        }
        this.fireServiceNotification(302);
        if (startPaused) {
            this.pause();
        }
        this.startListeners();
    }

    public final void pause() throws MuleException {
        this.doPause();
        this.paused.set(true);
        this.fireServiceNotification(304);
        this.logger.info((Object)("Mule Service " + this.name + " has been paused successfully"));
    }

    public final void resume() throws MuleException {
        this.doResume();
        this.paused.set(false);
        this.fireServiceNotification(305);
        this.logger.info((Object)("Mule Service " + this.name + " has been resumed successfully"));
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    protected void doPause() throws MuleException {
    }

    protected void doResume() throws MuleException {
    }

    public final void dispose() {
        try {
            if (!this.stopped.get()) {
                this.stop();
            }
        }
        catch (MuleException e) {
            this.logger.error((Object)("Failed to stop service: " + this.name), (Throwable)e);
        }
        this.doDispose();
        this.component.dispose();
        this.initialised.set(false);
        this.fireServiceNotification(306);
        this.muleContext.getStatistics().remove(this.stats);
    }

    public ServiceStatistics getStatistics() {
        return this.stats;
    }

    public void dispatchEvent(MuleEvent event) throws MuleException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ServiceException(CoreMessages.componentIsStopped(this.name), event.getMessage(), this);
        }
        ImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint instanceof OutboundEndpoint) {
            try {
                ((OutboundEndpoint)endpoint).dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            return;
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Service: " + this.name + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        this.doDispatch(event);
    }

    public MuleMessage sendEvent(MuleEvent event) throws MuleException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ServiceException(CoreMessages.componentIsStopped(this.name), event.getMessage(), this);
        }
        try {
            this.waitIfPaused(event);
        }
        catch (InterruptedException e) {
            throw new ServiceException(event.getMessage(), this, (Throwable)e);
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventSync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Service: " + this.name + " has received synchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        event = OptimizedRequestContext.unsafeSetEvent(event);
        return this.doSend(event);
    }

    protected void waitIfPaused(MuleEvent event) throws InterruptedException {
        if (this.logger.isDebugEnabled() && this.paused.get()) {
            this.logger.debug((Object)("Service: " + this.name + " is paused. Blocking call until resume is called"));
        }
        this.paused.whenFalse(null);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    protected void handleException(Exception e) {
        this.exceptionListener.exceptionThrown(e);
    }

    protected void doForceStop() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    protected void doStart() throws MuleException {
    }

    protected void doDispose() {
    }

    protected void doInitialise() throws InitialisationException {
    }

    public boolean isStarted() {
        return !this.stopped.get();
    }

    protected abstract MuleMessage doSend(MuleEvent var1) throws MuleException;

    protected abstract void doDispatch(MuleEvent var1) throws MuleException;

    protected void registerListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (InboundEndpoint endpoint : endpoints) {
            try {
                endpoint.getConnector().registerListener(this, endpoint);
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedtoRegisterOnEndpoint(this.name, endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void unregisterListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (InboundEndpoint endpoint : endpoints) {
            try {
                endpoint.getConnector().unregisterListener(this, endpoint);
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToUnregister(this.name, endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void startListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (InboundEndpoint endpoint : endpoints) {
            MessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null || !endpoint.getConnector().isStarted() || !endpoint.getInitialState().equals(INITIAL_STATE_STARTED)) continue;
            receiver.start();
        }
    }

    protected void stopListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (InboundEndpoint endpoint : endpoints) {
            MessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            receiver.stop();
        }
    }

    protected void connectListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (InboundEndpoint endpoint : endpoints) {
            AbstractConnector connector = (AbstractConnector)endpoint.getConnector();
            MessageReceiver receiver = connector.getReceiver(this, endpoint);
            if (receiver == null || !connector.isConnected()) continue;
            try {
                receiver.connect();
            }
            catch (Exception e) {
                throw new ModelException(MessageFactory.createStaticMessage("Failed to connect listener " + receiver + " for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    protected void disconnectListeners() throws MuleException {
        List endpoints = this.getIncomingEndpoints();
        for (InboundEndpoint endpoint : endpoints) {
            MessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            try {
                receiver.disconnect();
            }
            catch (Exception e) {
                throw new ModelException(MessageFactory.createStaticMessage("Failed to disconnect listener " + receiver + " for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    protected List getIncomingEndpoints() {
        ArrayList endpoints = new ArrayList();
        endpoints.addAll(this.inboundRouter.getEndpoints());
        if (this.responseRouter != null && this.responseRouter.getEndpoints() != null) {
            endpoints.addAll(this.responseRouter.getEndpoints());
        }
        return endpoints;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public InboundRouterCollection getInboundRouter() {
        return this.inboundRouter;
    }

    public void setInboundRouter(InboundRouterCollection inboundRouter) {
        this.inboundRouter = inboundRouter;
    }

    public OutboundRouterCollection getOutboundRouter() {
        return this.outboundRouter;
    }

    public void setOutboundRouter(OutboundRouterCollection outboundRouter) {
        this.outboundRouter = outboundRouter;
    }

    public ResponseRouterCollection getResponseRouter() {
        return this.responseRouter;
    }

    public void setResponseRouter(ResponseRouterCollection responseRouter) {
        this.responseRouter = responseRouter;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.component.setService(this);
    }

    protected void processReplyTo(MuleEvent event, MuleMessage result, ReplyToHandler replyToHandler, Object replyTo) throws MuleException {
        String requestor;
        if (result != null && replyToHandler != null && ((requestor = (String)result.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.getName()) || requestor == null)) {
            replyToHandler.processReplyTo(event, result, replyTo);
        }
    }

    protected ReplyToHandler getReplyToHandler(MuleMessage message, InboundEndpoint endpoint) {
        Object replyTo = message.getReplyTo();
        ReplyToHandler replyToHandler = null;
        if (replyTo != null) {
            replyToHandler = ((AbstractConnector)endpoint.getConnector()).getReplyToHandler();
            if (endpoint.getResponseTransformers() != null) {
                replyToHandler.setTransformers(endpoint.getResponseTransformers());
            }
        }
        return replyToHandler;
    }

    protected void dispatchToOutboundRouter(MuleEvent event, MuleMessage result) throws MessagingException {
        if (event.isStopFurtherProcessing()) {
            this.logger.debug((Object)"MuleEvent stop further processing has been set, no outbound routing will be performed.");
        }
        if (result != null && !event.isStopFurtherProcessing() && this.getOutboundRouter().hasEndpoints()) {
            this.getOutboundRouter().route(result, event.getSession());
            if (this.stats.isEnabled()) {
                this.stats.incSentEventASync();
            }
        }
    }

    protected MuleMessage sendToOutboundRouter(MuleEvent event, MuleMessage result) throws MessagingException {
        if (event.isStopFurtherProcessing()) {
            this.logger.debug((Object)"MuleEvent stop further processing has been set, no outbound routing will be performed.");
        }
        if (result != null && !event.isStopFurtherProcessing() && !(result.getPayload() instanceof NullPayload)) {
            if (this.getOutboundRouter().hasEndpoints()) {
                MuleMessage outboundReturnMessage = this.getOutboundRouter().route(new DefaultMuleMessage(result.getPayload(), result), event.getSession());
                if (outboundReturnMessage != null) {
                    result = outboundReturnMessage;
                }
                if (this.stats.isEnabled()) {
                    this.stats.incSentEventSync();
                }
            } else {
                this.logger.debug((Object)("Outbound router on service '" + this.getName() + "' doesn't have any endpoints configured."));
            }
        }
        return result;
    }

    protected MuleMessage processAsyncReplyRouter(MuleMessage result) throws MuleException {
        if (result != null && this.getResponseRouter() != null) {
            this.logger.debug((Object)"Waiting for response router message");
            result = this.getResponseRouter().getResponse(result);
        }
        return result;
    }

    protected MuleMessage invokeComponent(MuleEvent event) throws MuleException {
        return this.component.invoke(event);
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }
}

