/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CredentialsAccessor;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.security.EncryptionStrategyNotFoundException;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityManager;
import org.mule.api.security.SecurityProvider;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.security.MuleSecurityManager;
import org.mule.transformer.TransformerTemplate;
import org.mule.util.StringUtils;

public abstract class AbstractEndpointSecurityFilter
implements EndpointSecurityFilter,
MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected SecurityManager securityManager;
    private String securityProviders;
    protected ImmutableEndpoint endpoint;
    private boolean inbound = false;
    private boolean authenticate;
    private CredentialsAccessor credentialsAccessor;
    private boolean isInitialised = false;
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public final void initialise() throws InitialisationException {
        if (this.securityManager == null) {
            this.securityManager = this.muleContext.getSecurityManager();
        }
        if (this.securityManager == null) {
            throw new InitialisationException(CoreMessages.authSecurityManagerNotSet(), (Initialisable)this);
        }
        if (this.securityProviders != null) {
            MuleSecurityManager localManager = new MuleSecurityManager();
            String[] sp = StringUtils.splitAndTrim(this.securityProviders, ",");
            for (int i = 0; i < sp.length; ++i) {
                SecurityProvider provider = this.securityManager.getProvider(sp[i]);
                if (provider == null) {
                    throw new InitialisationException(CoreMessages.objectNotRegistered("Security Provider", sp[i]), (Initialisable)this);
                }
                localManager.addProvider(provider);
            }
            this.securityManager = localManager;
        }
    }

    protected final synchronized void lazyInit() throws InitialisationException {
        if (!this.isInitialised) {
            this.initialiseEndpoint();
            this.isInitialised = true;
        }
    }

    protected final void initialiseEndpoint() throws InitialisationException {
        if (this.endpoint == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("Endpoint"), (Initialisable)this);
        }
        if (this.endpoint instanceof InboundEndpoint) {
            this.inbound = true;
        } else if (this.endpoint instanceof OutboundEndpoint) {
            this.inbound = false;
        } else {
            throw new InitialisationException(CoreMessages.authEndpointMustSendOrReceive(), (Initialisable)this);
        }
        this.doInitialise();
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.authenticate = authenticate;
    }

    public void setSecurityManager(SecurityManager manager) {
        this.securityManager = manager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public String getSecurityProviders() {
        return this.securityProviders;
    }

    public void setSecurityProviders(String providers) {
        this.securityProviders = providers;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public synchronized void setEndpoint(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.isInitialised = false;
    }

    public void authenticate(MuleEvent event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
        this.lazyInit();
        if (this.inbound) {
            this.authenticateInbound(event);
        } else {
            this.authenticateOutbound(event);
        }
    }

    public CredentialsAccessor getCredentialsAccessor() {
        return this.credentialsAccessor;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    protected void updatePayload(MuleMessage message, final Object payload) throws TransformerException {
        TransformerTemplate trans = new TransformerTemplate(new TransformerTemplate.TransformerCallback(){

            public Object doTransform(MuleMessage message) throws Exception {
                return payload;
            }
        });
        message.applyTransformers(Arrays.asList(trans));
    }

    protected abstract void authenticateInbound(MuleEvent var1) throws SecurityException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, UnknownAuthenticationTypeException;

    protected abstract void authenticateOutbound(MuleEvent var1) throws SecurityException, SecurityProviderNotFoundException, CryptoFailureException;

    protected abstract void doInitialise() throws InitialisationException;
}

