/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.routing.RoutingException;
import org.mule.routing.EventCorrelatorCallback;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseAggregator;

public abstract class ResponseCorrelationAggregator
extends AbstractResponseAggregator {
    protected EventCorrelatorCallback getCorrelatorCallback() {
        return new DefaultEventCorrelatorCallback();
    }

    public class DefaultEventCorrelatorCallback
    implements EventCorrelatorCallback {
        public MuleMessage aggregateEvents(EventGroup events) throws RoutingException {
            return ResponseCorrelationAggregator.this.aggregateEvents(events);
        }

        public boolean shouldAggregateEvents(EventGroup events) {
            int expected = events.expectedSize();
            int current = events.size();
            if (expected == -1) {
                ResponseCorrelationAggregator.this.logger.warn((Object)"Correlation Group Size not set, but AbstractCorrelationAggregator is being used.  Message is being forwarded");
                return true;
            }
            if (ResponseCorrelationAggregator.this.logger.isDebugEnabled()) {
                ResponseCorrelationAggregator.this.logger.debug((Object)("Correlation size is " + expected + ", current event group size is " + current + " for correlation group " + events.getGroupId()));
            }
            return expected == current;
        }

        public EventGroup createEventGroup(MuleEvent event, Object id) {
            return new EventGroup(id, event.getMessage().getCorrelationGroupSize());
        }
    }
}

