/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.DynamicURIOutboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.util.TemplateParser;

public class FilteringOutboundRouter
extends AbstractOutboundRouter {
    private List transformers = new LinkedList();
    private Filter filter;
    private boolean useTemplates = false;
    private TemplateParser parser = TemplateParser.createSquareBracesStyleParser();
    protected ExpressionManager expressionManager;

    public void initialise() throws InitialisationException {
        super.initialise();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    public MuleMessage route(MuleMessage message, MuleSession session) throws RoutingException {
        MuleMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        OutboundEndpoint ep = this.getEndpoint(0, message);
        try {
            if (ep.isSynchronous()) {
                result = this.send(session, message, ep);
            } else {
                this.dispatch(session, message, ep);
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
        }
        return result;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean isMatch(MuleMessage message) throws RoutingException {
        if (this.getFilter() == null) {
            return true;
        }
        try {
            message.applyTransformers(this.transformers);
        }
        catch (TransformerException e) {
            throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), message, (ImmutableEndpoint)this.endpoints.get(0), e);
        }
        return this.getFilter().accept(message);
    }

    public List getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List transformers) {
        this.transformers = transformers;
    }

    public void addEndpoint(OutboundEndpoint endpoint) {
        if (!this.useTemplates && this.parser.isContainsTemplate(endpoint.getEndpointURI().toString())) {
            this.useTemplates = true;
        }
        super.addEndpoint(endpoint);
    }

    public OutboundEndpoint getEndpoint(int index, MuleMessage message) throws CouldNotRouteOutboundMessageException {
        if (!this.useTemplates) {
            return (OutboundEndpoint)this.endpoints.get(index);
        }
        OutboundEndpoint ep = (OutboundEndpoint)this.endpoints.get(index);
        String uri = ep.getEndpointURI().toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri before parsing is: " + uri));
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(ep.getProperties());
        for (String propertyKey : message.getPropertyNames()) {
            props.put(propertyKey, message.getProperty(propertyKey));
        }
        String newUriString = this.parser.parse(props, uri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri after parsing is: " + uri));
        }
        try {
            MuleEndpointURI newUri = new MuleEndpointURI(newUriString);
            if (!newUri.getScheme().equalsIgnoreCase(ep.getEndpointURI().getScheme())) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.schemeCannotChangeForRouter(ep.getEndpointURI().getScheme(), newUri.getScheme()), message, ep);
            }
            return new DynamicURIOutboundEndpoint(ep, newUri);
        }
        catch (EndpointException e) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.templateCausedMalformedEndpoint(uri, newUriString), message, ep, e);
        }
    }

    public boolean isUseTemplates() {
        return this.useTemplates;
    }

    public void setUseTemplates(boolean useTemplates) {
        this.useTemplates = useTemplates;
    }
}

