/*
 * Decompiled with CFR 0.152.
 */
package org.mule.interceptor;

import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.interceptor.Invocation;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;

public class InterceptorStack
implements Interceptor,
Initialisable,
Disposable {
    private List interceptors;

    public InterceptorStack() {
    }

    public InterceptorStack(List interceptors) {
        this.interceptors = interceptors;
    }

    public MuleMessage intercept(Invocation invocation) throws MuleException {
        return new Invoc(invocation).invoke();
    }

    public List getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List interceptors) {
        this.interceptors = interceptors;
    }

    public void initialise() throws InitialisationException {
        for (Interceptor interceptor : this.interceptors) {
            if (!(interceptor instanceof Initialisable)) continue;
            ((Initialisable)((Object)interceptor)).initialise();
        }
    }

    public void dispose() {
        for (Interceptor interceptor : this.interceptors) {
            if (!(interceptor instanceof Disposable)) continue;
            ((Disposable)((Object)interceptor)).dispose();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interceptors == null ? 0 : ((Object)this.interceptors).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterceptorStack other = (InterceptorStack)obj;
        return !(this.interceptors == null ? other.interceptors != null : !((Object)this.interceptors).equals(other.interceptors));
    }

    private class Invoc
    implements Invocation {
        private int cursor = 0;
        private Invocation invocation;

        public Invoc(Invocation invocation) {
            this.invocation = invocation;
        }

        public MuleMessage invoke() throws MuleException {
            if (InterceptorStack.this.interceptors != null && this.cursor < InterceptorStack.this.interceptors.size()) {
                Interceptor interceptor = (Interceptor)InterceptorStack.this.interceptors.get(this.cursor);
                ++this.cursor;
                this.setMessage(interceptor.intercept(this));
            } else {
                this.invocation.setMessage(this.getMessage());
                this.setMessage(this.invocation.invoke());
            }
            return this.getMessage();
        }

        public MuleEvent getEvent() {
            return this.invocation.getEvent();
        }

        public MuleMessage getMessage() {
            return this.invocation.getMessage();
        }

        public Service getService() {
            return this.invocation.getService();
        }

        public void setMessage(MuleMessage message) {
            this.invocation.setMessage(message);
        }
    }
}

