/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.RequiredValueException;
import org.mule.config.i18n.CoreMessages;

public class MessageHeadersExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "headers";
    public static final String DELIM = ",";
    public static final String ALL_ARGUMENT = "{all}";
    public static final String COUNT_ARGUMENT = "{count}";

    public Object evaluate(String expression, MuleMessage message) {
        HashMap<String, Object> result;
        if (ALL_ARGUMENT.equals(expression)) {
            result = new HashMap<String, Object>(message.getPropertyNames().size());
            for (String name : message.getPropertyNames()) {
                result.put(name, message.getProperty(name));
            }
        } else {
            if (COUNT_ARGUMENT.equals(expression)) {
                return message.getPropertyNames().size();
            }
            StringTokenizer tokenizer = new StringTokenizer(expression, DELIM);
            result = new HashMap(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                boolean required;
                String s = tokenizer.nextToken();
                if ((s = s.trim()).endsWith("*")) {
                    s = s.substring(0, s.length() - 1);
                    required = false;
                } else {
                    required = true;
                }
                Object val = message.getProperty(s);
                if (val != null) {
                    result.put(s, val);
                    continue;
                }
                if (!required) continue;
                throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull(NAME, expression));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }
}

