/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.util.List;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.interceptor.Invocation;
import org.mule.api.service.Service;
import org.mule.component.AbstractComponent;

public class ComponentInterceptorInvoker
implements Invocation {
    private final AbstractComponent component;
    private final List interceptors;
    private MuleEvent event;
    private int cursor = 0;

    public ComponentInterceptorInvoker(AbstractComponent component, List interceptors, MuleEvent event) {
        this.component = component;
        this.interceptors = interceptors;
        this.event = event;
    }

    public MuleMessage invoke() throws MuleException {
        if (this.cursor < this.interceptors.size()) {
            Interceptor interceptor = (Interceptor)this.interceptors.get(this.cursor++);
            return interceptor.intercept(this);
        }
        return this.component.intercept(this);
    }

    public MuleEvent getEvent() {
        return this.event;
    }

    public Service getService() {
        return this.component.getService();
    }

    public MuleMessage getMessage() {
        return this.event.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(MuleMessage message) {
        MuleEvent muleEvent = this.event;
        synchronized (muleEvent) {
            OptimizedRequestContext.unsafeRewriteEvent(message);
            this.event = RequestContext.getEvent();
        }
    }
}

