/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.security;

import org.mule.api.DefaultMuleException;
import org.mule.api.EncryptionStrategy;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;

public class CryptoFailureException
extends DefaultMuleException {
    private static final long serialVersionUID = 1336343718508294379L;
    private transient EncryptionStrategy encryptionStrategy;

    public CryptoFailureException(Message message, EncryptionStrategy strategy) {
        super(message);
        String s = strategy == null ? "null" : strategy.toString();
        this.addInfo("Encryption", s);
        this.encryptionStrategy = strategy;
    }

    public CryptoFailureException(Message message, EncryptionStrategy strategy, Throwable cause) {
        super(message, cause);
        String s = strategy == null ? "null" : strategy.toString();
        this.addInfo("Encryption", s);
        this.encryptionStrategy = strategy;
    }

    public CryptoFailureException(EncryptionStrategy strategy, Throwable cause) {
        super(CoreMessages.cryptoFailure(), cause);
        String s = strategy == null ? "null" : strategy.toString();
        this.addInfo("Encryption", s);
        this.encryptionStrategy = strategy;
    }

    public EncryptionStrategy getEncryptionStrategy() {
        return this.encryptionStrategy;
    }
}

