/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.AbstractAgent;
import org.mule.MuleServer;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;

public class ConfigScannerAgent
extends AbstractAgent {
    public static final String AGENT_NAME = "Mule Config Scanner";
    private static final Log logger = LogFactory.getLog(ConfigScannerAgent.class);
    private String configDirName = null;
    private File configDir = null;
    private int sleepInterval = 5000;
    private boolean doStop = false;
    private ScannerThread scannerThread = null;

    public ConfigScannerAgent() {
        super(AGENT_NAME);
    }

    public String getConfigDirName() {
        return this.configDirName;
    }

    public void setConfigDirName(String configDirName) {
        this.configDirName = configDirName;
    }

    public String getDescription() {
        return this.getName() + " scanning for files in " + this.configDirName;
    }

    public void start() throws MuleException {
        this.scannerThread = new ScannerThread();
        this.scannerThread.start();
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void initialise() throws InitialisationException {
        if (this.configDirName == null) {
            String workDir = this.muleContext.getConfiguration().getWorkingDirectory();
            this.configDirName = workDir + "/conf";
        }
        try {
            this.configDir = FileUtils.openDirectory(this.configDirName);
        }
        catch (IOException ioe) {
            throw new InitialisationException((Throwable)ioe, (Initialisable)this);
        }
    }

    public List getDependentAgents() {
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return this.getDescription();
    }

    public void setDoStop(boolean doStop) {
        this.doStop = doStop;
    }

    private void processConfigFile(String configFile) {
        try {
            Class cfgBuilderClass = ClassUtils.loadClass("org.mule.config.spring.SpringXmlConfigurationBuilder", MuleServer.class);
            ConfigurationBuilder cfgBuilder = (ConfigurationBuilder)ClassUtils.instanciateClass(cfgBuilderClass, new Object[]{configFile});
            if (!cfgBuilder.isConfigured()) {
                cfgBuilder.configure(this.muleContext);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    class ScannerThread
    extends Thread {
        int errorCount = 0;
        int errorThreshold = 3;
        List processedFiles = new ArrayList();

        ScannerThread() {
        }

        public void run() {
            while (!ConfigScannerAgent.this.doStop && this.errorCount < this.errorThreshold) {
                try {
                    File[] configFiles = ConfigScannerAgent.this.configDir.listFiles();
                    for (int i = 0; i < configFiles.length; ++i) {
                        File configFile = configFiles[i];
                        String path = configFile.getCanonicalPath();
                        if (this.processedFiles.contains(path)) {
                            configFile.delete();
                            if (!configFile.exists()) continue;
                            this.processedFiles.remove(this.processedFiles.indexOf(path));
                            continue;
                        }
                        logger.info((Object)path);
                        ConfigScannerAgent.this.processConfigFile(path);
                        configFile.delete();
                        this.processedFiles.add(path);
                    }
                }
                catch (IOException ioe) {
                    logger.error((Object)("Unable to check directory: " + ioe.toString()));
                    ++this.errorCount;
                }
                try {
                    ScannerThread.sleep(ConfigScannerAgent.this.sleepInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

