/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.util.Collection;
import java.util.Iterator;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.JavaComponent;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.component.LifecycleAdapterFactory;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.object.ObjectFactory;
import org.mule.api.routing.NestedRouterCollection;
import org.mule.component.AbstractComponent;
import org.mule.component.NullLifecycleAdapter;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.routing.nested.DefaultNestedRouterCollection;

public abstract class AbstractJavaComponent
extends AbstractComponent
implements JavaComponent {
    protected EntryPointResolverSet entryPointResolverSet;
    protected NestedRouterCollection nestedRouter = new DefaultNestedRouterCollection();
    protected ObjectFactory objectFactory;
    protected LifecycleAdapterFactory lifecycleAdapterFactory;

    public AbstractJavaComponent() {
    }

    public AbstractJavaComponent(ObjectFactory objectFactory) {
        this(objectFactory, null, null);
    }

    public AbstractJavaComponent(ObjectFactory objectFactory, EntryPointResolverSet entryPointResolverSet, NestedRouterCollection nestedRouterCollection) {
        this.objectFactory = objectFactory;
        this.entryPointResolverSet = entryPointResolverSet;
        if (nestedRouterCollection != null) {
            this.nestedRouter = nestedRouterCollection;
        }
    }

    protected Object doInvoke(MuleEvent event) throws Exception {
        return this.invokeComponentInstance(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeComponentInstance(MuleEvent event) throws Exception {
        LifecycleAdapter componentLifecycleAdapter = null;
        try {
            componentLifecycleAdapter = this.borrowComponentLifecycleAdaptor();
            Object object = componentLifecycleAdapter.invoke(event);
            return object;
        }
        finally {
            this.returnComponentLifecycleAdaptor(componentLifecycleAdapter);
        }
    }

    public Class getObjectType() {
        return this.objectFactory.getObjectClass();
    }

    protected LifecycleAdapter createLifeCycleAdaptor() throws MuleException, Exception {
        LifecycleAdapter lifecycleAdapter = this.lifecycleAdapterFactory != null ? this.lifecycleAdapterFactory.create(this.objectFactory.getInstance(), this, this.entryPointResolverSet) : (this.objectFactory.isExternallyManagedLifecycle() ? new NullLifecycleAdapter(this.objectFactory.getInstance(), this, this.entryPointResolverSet) : this.service.getModel().getLifecycleAdapterFactory().create(this.objectFactory.getInstance(), this, this.entryPointResolverSet));
        lifecycleAdapter.initialise();
        return lifecycleAdapter;
    }

    protected abstract LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception;

    protected abstract void returnComponentLifecycleAdaptor(LifecycleAdapter var1) throws Exception;

    protected void doInitialise() throws InitialisationException {
        if (this.objectFactory == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("object factory"), (Initialisable)this);
        }
        this.objectFactory.initialise();
    }

    protected void doStart() throws MuleException {
        if (this.entryPointResolverSet == null) {
            this.entryPointResolverSet = this.service.getModel().getEntryPointResolverSet();
        }
    }

    protected void doDispose() {
    }

    public EntryPointResolverSet getEntryPointResolverSet() {
        return this.entryPointResolverSet;
    }

    public NestedRouterCollection getNestedRouter() {
        return this.nestedRouter;
    }

    public void setEntryPointResolverSet(EntryPointResolverSet entryPointResolverSet) {
        this.entryPointResolverSet = entryPointResolverSet;
    }

    public void setNestedRouter(NestedRouterCollection nestedRouter) {
        this.nestedRouter = nestedRouter;
    }

    public void setEntryPointResolvers(Collection entryPointResolvers) {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new DefaultEntryPointResolverSet();
        }
        Iterator resolvers = entryPointResolvers.iterator();
        while (resolvers.hasNext()) {
            this.entryPointResolverSet.addEntryPointResolver((EntryPointResolver)resolvers.next());
        }
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public LifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    public void setLifecycleAdapterFactory(LifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }
}

