/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.expression;

import org.mule.config.i18n.CoreMessages;
import org.mule.util.StringUtils;
import org.mule.util.expression.ExpressionEvaluatorManager;

public class ExpressionConfig {
    public static final String CUSTOM_EVALUATOR = "custom";
    public static final String EXPRESSION_SEPARATOR = ":";
    private String expression;
    private String evaluator;
    private String customEvaluator;
    private String fullExpression;
    private String expressionPrefix = "#[";
    private String expressionPostfix = "]";

    public ExpressionConfig() {
    }

    public ExpressionConfig(String expression, String evaluator, String customEvaluator) {
        this(expression, evaluator, customEvaluator, "#[", "]");
    }

    public ExpressionConfig(String expression, String evaluator, String customEvaluator, String expressionPrefix, String expressionPostfix) {
        this.setCustomEvaluator(customEvaluator);
        this.setEvaluator(evaluator);
        this.setExpression(expression);
        this.expressionPostfix = expressionPostfix;
        this.expressionPrefix = expressionPrefix;
    }

    public void validate() {
        if (this.expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (this.evaluator == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("evaluator").getMessage());
        }
        if (CUSTOM_EVALUATOR.equalsIgnoreCase(this.evaluator)) {
            if (this.customEvaluator == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("custom evaluator").getMessage());
            }
            this.evaluator = this.customEvaluator;
        }
        if (!ExpressionEvaluatorManager.isEvaluatorRegistered(this.evaluator)) {
            throw new IllegalArgumentException(CoreMessages.expressionEvaluatorNotRegistered(this.evaluator).getMessage());
        }
    }

    public String getFullExpression() {
        if (this.fullExpression == null) {
            this.validate();
            this.fullExpression = this.expressionPrefix + this.evaluator + EXPRESSION_SEPARATOR + this.expression + this.expressionPostfix;
        }
        return this.fullExpression;
    }

    public String getCustomEvaluator() {
        return this.customEvaluator;
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.customEvaluator = StringUtils.trimToNull((String)customEvaluator);
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(String evaluator) {
        this.evaluator = StringUtils.trimToNull((String)evaluator);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = StringUtils.trimToNull((String)expression);
    }
}

