/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.util.Iterator;
import java.util.List;
import javax.resource.spi.work.Work;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transport.Connector;
import org.mule.transaction.TransactionTemplate;
import org.mule.transport.AbstractPollingMessageReceiver;

public abstract class TransactedPollingMessageReceiver
extends AbstractPollingMessageReceiver {
    private boolean receiveMessagesInTransaction = true;
    private boolean useMultipleReceivers = true;

    public TransactedPollingMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
    }

    public TransactedPollingMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint, long frequency) throws CreateException {
        this(connector, service, endpoint);
        this.setFrequency(frequency);
    }

    public boolean isReceiveMessagesInTransaction() {
        return this.receiveMessagesInTransaction;
    }

    public void setReceiveMessagesInTransaction(boolean useTx) {
        this.receiveMessagesInTransaction = useTx;
    }

    public boolean isUseMultipleTransactedReceivers() {
        return this.useMultipleReceivers;
    }

    public void setUseMultipleTransactedReceivers(boolean useMultiple) {
        this.useMultipleReceivers = useMultiple;
    }

    public void doStart() throws MuleException {
        this.setUseMultipleTransactedReceivers(this.connector.isCreateMultipleTransactedReceivers());
        ThreadingProfile tp = this.connector.getReceiverThreadingProfile();
        int numReceiversToStart = 1;
        if (this.isReceiveMessagesInTransaction() && this.isUseMultipleTransactedReceivers() && tp.isDoThreading()) {
            numReceiversToStart = this.connector.getNumberOfConcurrentTransactedReceivers();
        }
        for (int i = 0; i < numReceiversToStart; ++i) {
            super.doStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        TransactionTemplate tt = new TransactionTemplate(this.endpoint.getTransactionConfig(), this.connector.getExceptionListener(), this.connector.getMuleContext());
        if (this.isReceiveMessagesInTransaction()) {
            TransactionCallback cb = new TransactionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInTransaction() throws Exception {
                    if (TransactedPollingMessageReceiver.this.useStrictConnectDisconnect) {
                        TransactedPollingMessageReceiver.this.connect();
                    }
                    try {
                        List messages = TransactedPollingMessageReceiver.this.getMessages();
                        if (messages != null && messages.size() > 0) {
                            Iterator it = messages.iterator();
                            while (it.hasNext()) {
                                TransactedPollingMessageReceiver.this.processMessage(it.next());
                            }
                        }
                    }
                    finally {
                        if (TransactedPollingMessageReceiver.this.useStrictConnectDisconnect) {
                            TransactedPollingMessageReceiver.this.disconnect();
                        }
                    }
                    return null;
                }
            };
            tt.execute(cb);
        } else {
            if (this.useStrictConnectDisconnect) {
                this.connect();
            }
            try {
                List messages = this.getMessages();
                if (messages != null && messages.size() > 0) {
                    CountDownLatch countdown = new CountDownLatch(messages.size());
                    Iterator it = messages.iterator();
                    while (it.hasNext()) {
                        try {
                            this.getWorkManager().scheduleWork(new MessageProcessorWorker(tt, countdown, it.next()));
                        }
                        catch (Exception e) {
                            countdown.countDown();
                            throw e;
                        }
                    }
                    countdown.await();
                }
            }
            finally {
                if (this.useStrictConnectDisconnect) {
                    this.disconnect();
                }
            }
        }
    }

    protected abstract List getMessages() throws Exception;

    protected abstract void processMessage(Object var1) throws Exception;

    protected class MessageProcessorWorker
    implements Work,
    TransactionCallback {
        private final TransactionTemplate tt;
        private final Object message;
        private final CountDownLatch latch;

        public MessageProcessorWorker(TransactionTemplate tt, CountDownLatch latch, Object message) {
            this.tt = tt;
            this.message = message;
            this.latch = latch;
        }

        public void release() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.tt.execute(this);
            }
            catch (Exception e) {
                TransactedPollingMessageReceiver.this.handleException(e);
            }
            finally {
                this.latch.countDown();
            }
        }

        public Object doInTransaction() throws Exception {
            TransactedPollingMessageReceiver.this.processMessage(this.message);
            return null;
        }
    }
}

