/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.Map;
import javax.activation.DataHandler;
import org.mule.api.MuleRuntimeException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MutableMessageAdapter;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.NullPayload;

public final class DefaultMessageAdapter
extends AbstractMessageAdapter
implements MutableMessageAdapter {
    private static final long serialVersionUID = 1908152148142575505L;
    protected Object message;

    protected DefaultMessageAdapter() {
    }

    public DefaultMessageAdapter(Object message) {
        this.message = message == null ? NullPayload.getInstance() : message;
    }

    public DefaultMessageAdapter(Object message, MessageAdapter previous) {
        super(previous);
        if (previous != null) {
            this.message = message == null ? NullPayload.getInstance() : message;
            for (String name : previous.getAttachmentNames()) {
                try {
                    DataHandler dh = previous.getAttachment(name);
                    if (null == dh) {
                        logger.warn((Object)("Detected concurrent access to attachment " + name + " for " + previous));
                        continue;
                    }
                    this.addAttachment(name, dh);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadPayload(), (Throwable)e);
                }
            }
            for (String name : previous.getPropertyNames()) {
                try {
                    Object value = previous.getProperty(name);
                    if (null == value) {
                        logger.warn((Object)("Detected concurrent access to property " + name + " for " + previous));
                        continue;
                    }
                    this.setProperty(name, value);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadPayload(), (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("previousAdapter may not be null");
        }
    }

    public DefaultMessageAdapter(Object message, Map properties, Map attachments) {
        this(message);
        if (properties != null) {
            this.properties.addInboundProperties(properties);
        }
        if (attachments != null) {
            this.attachments.putAll(attachments);
        }
    }

    public Object getPayload() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(Object payload) {
        Object object = this.message;
        synchronized (object) {
            this.message = payload;
        }
    }

    public String getUniqueId() {
        return this.id;
    }

    public ThreadSafeAccess newThreadCopy() {
        return new DefaultMessageAdapter(this.getPayload(), this);
    }
}

