/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.mule.RequestContext;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.transformer.simple.SerializableToByteArray;

public class ObjectToInputStream
extends SerializableToByteArray {
    public ObjectToInputStream() {
        this.registerSourceType(String.class);
        this.registerSourceType(OutputHandler.class);
        this.setReturnClass(InputStream.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            if (src instanceof String) {
                return new ByteArrayInputStream(((String)src).getBytes(encoding));
            }
            if (src instanceof OutputHandler) {
                OutputHandler oh = (OutputHandler)src;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                oh.write(RequestContext.getEvent(), out);
                return new ByteArrayInputStream(out.toByteArray());
            }
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
        byte[] bytes = (byte[])super.doTransform(src, encoding);
        return new ByteArrayInputStream(bytes);
    }
}

