/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMessageCollection;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.routing.AggregationException;
import org.mule.routing.EventCorrelatorCallback;
import org.mule.routing.inbound.EventGroup;

public class CollectionCorrelatorCallback
implements EventCorrelatorCallback {
    protected final transient Log logger = LogFactory.getLog(CollectionCorrelatorCallback.class);

    public MuleMessage aggregateEvents(EventGroup events) throws AggregationException {
        DefaultMessageCollection message = new DefaultMessageCollection();
        message.addMessages(events.toArray());
        return message;
    }

    public EventGroup createEventGroup(MuleEvent event, Object groupId) {
        return new EventGroup(groupId, event.getMessage().getCorrelationGroupSize());
    }

    public boolean shouldAggregateEvents(EventGroup events) {
        int size = events.expectedSize();
        if (size == -1) {
            this.logger.warn((Object)"Correlation Group Size not set, but CorrelationAggregator is being used. Message is being forwarded");
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Correlation size is " + size + ". Current event group size is " + events.size() + " for correlation " + events.getGroupId()));
        }
        return size == events.size();
    }
}

