/*
 * Decompiled with CFR 0.152.
 */
package org.mule.object;

import java.util.Map;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.object.AbstractObjectFactory;

public class SingletonObjectFactory
extends AbstractObjectFactory {
    private Object instance = null;

    public SingletonObjectFactory() {
    }

    public SingletonObjectFactory(String objectClassName) {
        super(objectClassName);
    }

    public SingletonObjectFactory(String objectClassName, Map properties) {
        super(objectClassName, properties);
    }

    public SingletonObjectFactory(Class objectClass) {
        super(objectClass);
    }

    public SingletonObjectFactory(Class objectClass, Map properties) {
        super(objectClass, properties);
    }

    public SingletonObjectFactory(Object instance) {
        super(instance.getClass());
        this.instance = instance;
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.instance == null) {
            try {
                this.instance = super.getInstance();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public void dispose() {
        this.instance = null;
        super.dispose();
    }

    public Object getInstance() throws Exception {
        if (this.instance != null) {
            return this.instance;
        }
        throw new InitialisationException(MessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
    }

    public Class getObjectClass() {
        if (this.instance != null) {
            return this.instance.getClass();
        }
        return super.getObjectClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

