/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.VoidResult;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.interceptor.Invocation;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.DisposeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceException;
import org.mule.api.transformer.TransformerException;
import org.mule.component.ComponentInterceptorInvoker;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ComponentMessageNotification;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.mule.management.stats.ComponentStatistics;
import org.mule.transformer.TransformerTemplate;
import org.mule.transport.NullPayload;

public abstract class AbstractComponent
implements Component,
Interceptor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Service service;
    protected ComponentStatistics statistics = null;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean stopping = new AtomicBoolean(false);
    protected final AtomicBoolean initialised = new AtomicBoolean(false);
    protected final AtomicBoolean disposing = new AtomicBoolean(false);
    protected final AtomicBoolean disposed = new AtomicBoolean(false);
    protected ServerNotificationHandler notificationHandler;
    protected List interceptors = new ArrayList();

    public List getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List interceptors) {
        this.interceptors = interceptors;
    }

    public AbstractComponent() {
        this.statistics = new ComponentStatistics();
    }

    public MuleMessage intercept(Invocation invocation) throws MuleException {
        return this.invokeInternal(invocation.getEvent());
    }

    private MuleMessage invokeInternal(MuleEvent event) throws DisposeException, DefaultMuleException, MuleException, ServiceException {
        OptimizedRequestContext.unsafeSetEvent(event);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking " + this.getClass().getName() + "component for service " + this.service.getName()));
        }
        this.checkDisposed();
        if (!(event.getEndpoint() instanceof InboundEndpoint)) {
            throw new IllegalStateException("Unable to process outbound event, components only process incoming events.");
        }
        if (this.stopping.get() || !this.started.get()) {
            throw new DefaultMuleException(CoreMessages.componentIsStopped(this.service.getName()));
        }
        try {
            this.fireComponentNotification(event.getMessage(), 1401);
            long startTime = 0L;
            if (this.statistics.isEnabled()) {
                startTime = System.currentTimeMillis();
            }
            Object result = this.doInvoke(event);
            if (this.statistics.isEnabled()) {
                this.statistics.addExecutionTime(System.currentTimeMillis() - startTime);
            }
            MuleMessage resultMessage = this.createResultMessage(event, result);
            this.fireComponentNotification(resultMessage, 1402);
            return resultMessage;
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ServiceException(CoreMessages.failedToInvoke(this.toString()), event.getMessage(), this.service, e);
        }
    }

    public MuleMessage invoke(MuleEvent event) throws MuleException {
        if (this.interceptors.isEmpty()) {
            return this.invokeInternal(event);
        }
        return new ComponentInterceptorInvoker(this, this.interceptors, event).invoke();
    }

    protected MuleMessage createResultMessage(MuleEvent event, Object result) throws TransformerException {
        if (result instanceof MuleMessage) {
            return (MuleMessage)result;
        }
        if (result instanceof VoidResult) {
            event.transformMessage();
            return event.getMessage();
        }
        if (result != null) {
            event.getMessage().applyTransformers(Collections.singletonList(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
            return event.getMessage();
        }
        return new DefaultMuleMessage(NullPayload.getInstance());
    }

    protected abstract Object doInvoke(MuleEvent var1) throws Exception;

    public String toString() {
        return this.getClass().getName() + " component for: " + this.service.toString();
    }

    public void release() {
    }

    public ComponentStatistics getStatistics() {
        return this.statistics;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Service getService() {
        return this.service;
    }

    public final void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Initialising: " + this));
            }
            if (this.service == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage("Component has not been initialized properly, no service."), (Initialisable)this);
            }
            this.doInitialise();
            this.initialised.set(true);
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disposing.set(true);
        try {
            if (this.started.get()) {
                this.stop();
            }
        }
        catch (MuleException e) {
            this.logger.error((Object)CoreMessages.failedToStop(this.toString()));
        }
        try {
            this.doDispose();
        }
        catch (Exception e) {
            this.logger.warn(CoreMessages.failedToDispose(this.toString()), (Throwable)e);
        }
        finally {
            this.disposed.set(true);
            this.disposing.set(false);
            this.initialised.set(false);
        }
    }

    protected void doDispose() {
    }

    public void stop() throws MuleException {
        if (!this.disposed.get() && this.started.get() && !this.stopping.get()) {
            this.stopping.set(true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Stopping: " + this));
            }
            this.doStop();
            this.started.set(false);
            this.stopping.set(false);
        }
    }

    protected void doStart() throws MuleException {
    }

    public void start() throws MuleException {
        this.checkDisposed();
        if (!this.started.get()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Starting: " + this));
            }
            this.notificationHandler = new OptimisedNotificationHandler(this.service.getMuleContext().getNotificationManager(), ComponentMessageNotification.class);
            this.doStart();
            this.started.set(true);
        }
    }

    protected void doStop() throws MuleException {
    }

    protected void checkDisposed() throws DisposeException {
        if (this.disposed.get()) {
            throw new DisposeException(CoreMessages.createStaticMessage("Cannot use a disposed component"), (Disposable)this);
        }
    }

    protected void fireComponentNotification(MuleMessage message, int action) {
        if (this.notificationHandler.isNotificationEnabled(ComponentMessageNotification.class)) {
            this.notificationHandler.fireNotification(new ComponentMessageNotification(message, this, action));
        }
    }
}

