/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.transport.NullPayload;

public class MessagingException
extends MuleException {
    private static final long serialVersionUID = 6941498759267936649L;
    protected final transient MuleMessage umoMessage;

    public MessagingException(Message message, MuleMessage umoMessage) {
        this.umoMessage = umoMessage;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleMessage umoMessage, Throwable cause) {
        super(cause);
        this.umoMessage = umoMessage;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, Object payload) {
        this.umoMessage = payload == null ? RequestContext.getEventContext().getMessage() : new DefaultMuleMessage(payload, (Map)null);
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, Object payload, Throwable cause) {
        super(cause);
        this.umoMessage = payload == null ? RequestContext.getEventContext().getMessage() : new DefaultMuleMessage(payload, (Map)null);
        this.setMessage(this.generateMessage(message));
    }

    private String generateMessage(Message message) {
        StringBuffer buf = new StringBuffer(80);
        if (message != null) {
            buf.append(message.getMessage()).append(". ");
        }
        if (this.umoMessage != null) {
            Object payload = this.umoMessage.getPayload();
            if (payload == null) {
                payload = NullPayload.getInstance();
            }
            buf.append(CoreMessages.messageIsOfType(payload.getClass()).getMessage());
            this.addInfo("Payload", payload.toString());
        } else {
            buf.append("The current MuleMessage is null! Please report this to ").append(MuleManifest.getDevListEmail());
            this.addInfo("Payload", NullPayload.getInstance().toString());
        }
        return buf.toString();
    }

    public MuleMessage getUmoMessage() {
        return this.umoMessage;
    }
}

